"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulaTimeRangeFn = exports.formulaNowFn = exports.formulaIntervalFn = void 0;
var _common = require("@kbn/data-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeRangeAsNumber = (timeRange, now) => {
  if (!timeRange) return 0;
  const absoluteTimeRange = (0, _common.getAbsoluteTimeRange)(timeRange, now != null ? {
    forceNow: new Date(now)
  } : {});
  return timeRange ? (0, _moment.default)(absoluteTimeRange.to).diff((0, _moment.default)(absoluteTimeRange.from)) : 0;
};
const formulaTimeRangeFn = {
  name: 'formula_time_range',
  help: _i18n.i18n.translate('xpack.lens.formula.timeRange.help', {
    defaultMessage: 'The specified time range, in milliseconds (ms).'
  }),
  args: {},
  fn(_input, _args, {
    getSearchContext
  }) {
    const {
      timeRange,
      now
    } = getSearchContext();
    return getTimeRangeAsNumber(timeRange, now);
  }
};
exports.formulaTimeRangeFn = formulaTimeRangeFn;
const formulaIntervalFn = {
  name: 'formula_interval',
  help: _i18n.i18n.translate('xpack.lens.formula.interval.help', {
    defaultMessage: 'The specified minimum interval for the date histogram, in milliseconds (ms).'
  }),
  args: {
    targetBars: {
      types: ['number'],
      help: _i18n.i18n.translate('xpack.lens.formula.interval.targetBars.help', {
        defaultMessage: 'The target number of bars for the date histogram.'
      })
    }
  },
  fn(_input, args, {
    getSearchContext
  }) {
    const {
      timeRange,
      now
    } = getSearchContext();
    return timeRange && args.targetBars ? (0, _common.calcAutoIntervalNear)(args.targetBars, getTimeRangeAsNumber(timeRange, now)).asMilliseconds() : 0;
  }
};
exports.formulaIntervalFn = formulaIntervalFn;
const formulaNowFn = {
  name: 'formula_now',
  help: _i18n.i18n.translate('xpack.lens.formula.now.help', {
    defaultMessage: 'The current now moment used in Kibana expressed in milliseconds (ms).'
  }),
  args: {},
  fn(_input, _args, {
    getSearchContext
  }) {
    var _getSearchContext$now;
    return (_getSearchContext$now = getSearchContext().now) !== null && _getSearchContext$now !== void 0 ? _getSearchContext$now : Date.now();
  }
};
exports.formulaNowFn = formulaNowFn;