"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XYDataLayer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../utils");
var _formula = require("./columns/formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BREAKDOWN_COLUMN_NAME = 'aggs_breakdown';
const HISTOGRAM_COLUMN_NAME = 'x_date_histogram';
class XYDataLayer {
  constructor(layerConfig) {
    var _layerConfig$layerTyp, _layerConfig$options;
    (0, _defineProperty2.default)(this, "column", void 0);
    (0, _defineProperty2.default)(this, "layerConfig", void 0);
    this.column = layerConfig.data.map(dataItem => new _formula.FormulaColumn(dataItem));
    this.layerConfig = {
      ...layerConfig,
      layerType: (_layerConfig$layerTyp = layerConfig.layerType) !== null && _layerConfig$layerTyp !== void 0 ? _layerConfig$layerTyp : 'data',
      options: {
        ...layerConfig.options,
        buckets: {
          type: 'date_histogram',
          ...((_layerConfig$options = layerConfig.options) === null || _layerConfig$options === void 0 ? void 0 : _layerConfig$options.buckets)
        }
      }
    };
  }
  getName() {
    return this.column[0].getValueConfig().label;
  }
  getBaseLayer(dataView, options) {
    var _options$buckets, _options$buckets$fiel, _options$breakdown;
    return {
      ...(((_options$buckets = options.buckets) === null || _options$buckets === void 0 ? void 0 : _options$buckets.type) === 'date_histogram' ? (0, _utils.getHistogramColumn)({
        columnName: HISTOGRAM_COLUMN_NAME,
        options: {
          params: {
            ...options.buckets.params
          },
          sourceField: (_options$buckets$fiel = options.buckets.field) !== null && _options$buckets$fiel !== void 0 ? _options$buckets$fiel : dataView.timeFieldName
        }
      }) : {}),
      ...(((_options$breakdown = options.breakdown) === null || _options$breakdown === void 0 ? void 0 : _options$breakdown.type) === 'top_values' ? {
        ...(0, _utils.getTopValuesColumn)({
          columnName: BREAKDOWN_COLUMN_NAME,
          field: options === null || options === void 0 ? void 0 : options.breakdown.field,
          options: {
            ...options.breakdown.params
          }
        })
      } : {})
    };
  }
  getLayer(layerId, accessorId, chartDataView, formulaAPI) {
    var _this$layerConfig$opt, _this$layerConfig$opt2, _this$layerConfig$opt3, _this$layerConfig$opt4, _this$layerConfig$dat, _this$layerConfig$opt5;
    const columnOrder = [];
    if (((_this$layerConfig$opt = this.layerConfig.options) === null || _this$layerConfig$opt === void 0 ? void 0 : (_this$layerConfig$opt2 = _this$layerConfig$opt.breakdown) === null || _this$layerConfig$opt2 === void 0 ? void 0 : _this$layerConfig$opt2.type) === 'top_values') {
      columnOrder.push(BREAKDOWN_COLUMN_NAME);
    }
    if (((_this$layerConfig$opt3 = this.layerConfig.options) === null || _this$layerConfig$opt3 === void 0 ? void 0 : (_this$layerConfig$opt4 = _this$layerConfig$opt3.buckets) === null || _this$layerConfig$opt4 === void 0 ? void 0 : _this$layerConfig$opt4.type) === 'date_histogram') {
      columnOrder.push(HISTOGRAM_COLUMN_NAME);
    }
    const baseLayer = {
      columnOrder,
      columns: {
        ...this.getBaseLayer((_this$layerConfig$dat = this.layerConfig.dataView) !== null && _this$layerConfig$dat !== void 0 ? _this$layerConfig$dat : chartDataView, (_this$layerConfig$opt5 = this.layerConfig.options) !== null && _this$layerConfig$opt5 !== void 0 ? _this$layerConfig$opt5 : {})
      }
    };
    return {
      [layerId]: this.column.reduce((acc, curr, index) => {
        var _this$layerConfig$dat2;
        return {
          ...acc,
          ...curr.getData(`${accessorId}_${index}`, acc, (_this$layerConfig$dat2 = this.layerConfig.dataView) !== null && _this$layerConfig$dat2 !== void 0 ? _this$layerConfig$dat2 : chartDataView, formulaAPI)
        };
      }, baseLayer)
    };
  }
  getReference(layerId, chartDataView) {
    var _this$layerConfig$dat3;
    return (0, _utils.getDefaultReferences)((_this$layerConfig$dat3 = this.layerConfig.dataView) !== null && _this$layerConfig$dat3 !== void 0 ? _this$layerConfig$dat3 : chartDataView, layerId);
  }
  getLayerConfig(layerId, accessorId) {
    var _this$layerConfig$opt6, _this$layerConfig$opt7, _this$layerConfig$opt8, _this$layerConfig$opt9, _this$layerConfig$opt10, _this$layerConfig$opt11;
    return {
      layerId,
      seriesType: (_this$layerConfig$opt6 = (_this$layerConfig$opt7 = this.layerConfig.options) === null || _this$layerConfig$opt7 === void 0 ? void 0 : _this$layerConfig$opt7.seriesType) !== null && _this$layerConfig$opt6 !== void 0 ? _this$layerConfig$opt6 : 'line',
      accessors: this.column.map((_, index) => `${accessorId}_${index}`),
      yConfig: this.layerConfig.data.map(({
        color
      }, index) => color ? {
        forAccessor: `${accessorId}_${index}`,
        color
      } : undefined).filter(_utils.nonNullable),
      layerType: 'data',
      xAccessor: ((_this$layerConfig$opt8 = this.layerConfig.options) === null || _this$layerConfig$opt8 === void 0 ? void 0 : (_this$layerConfig$opt9 = _this$layerConfig$opt8.buckets) === null || _this$layerConfig$opt9 === void 0 ? void 0 : _this$layerConfig$opt9.type) === 'date_histogram' ? HISTOGRAM_COLUMN_NAME : undefined,
      splitAccessor: ((_this$layerConfig$opt10 = this.layerConfig.options) === null || _this$layerConfig$opt10 === void 0 ? void 0 : (_this$layerConfig$opt11 = _this$layerConfig$opt10.breakdown) === null || _this$layerConfig$opt11 === void 0 ? void 0 : _this$layerConfig$opt11.type) === 'top_values' ? BREAKDOWN_COLUMN_NAME : undefined
    };
  }
  getDataView() {
    return this.layerConfig.dataView;
  }
}
exports.XYDataLayer = XYDataLayer;