"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentWidget = exports.PERCENT_DATA_TEST_ID = exports.LOADING_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _hooks = require("../../hooks");
var _add_timerange_and_default_filter_to_query = require("../../utils/add_timerange_and_default_filter_to_query");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_TEST_ID = 'kubernetesSecurity:percentWidgetLoading';
exports.LOADING_TEST_ID = LOADING_TEST_ID;
const PERCENT_DATA_TEST_ID = 'kubernetesSecurity:percentWidgetData';
exports.PERCENT_DATA_TEST_ID = PERCENT_DATA_TEST_ID;
const PercentWidget = ({
  title,
  dataValueMap,
  widgetKey,
  indexPattern,
  globalFilter,
  groupedBy,
  countBy,
  onReduce
}) => {
  const [hoveredFilter, setHoveredFilter] = (0, _react.useState)(null);
  const styles = (0, _styles.useStyles)();
  const filterQueryWithTimeRange = (0, _react.useMemo)(() => {
    return (0, _add_timerange_and_default_filter_to_query.addTimerangeAndDefaultFilterToQuery)(globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate);
  }, [globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate]);
  const {
    data,
    isLoading
  } = (0, _hooks2.useFetchPercentWidgetData)(onReduce, filterQueryWithTimeRange, widgetKey, groupedBy, countBy, indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title);
  const {
    getFilterForValueButton,
    getFilterOutValueButton,
    filterManager
  } = (0, _hooks.useSetFilter)();
  const dataValueSum = (0, _react.useMemo)(() => data ? Object.keys(data).reduce((sumSoFar, current) => sumSoFar + data[current], 0) : 0, [data]);
  const filterButtons = (0, _react.useMemo)(() => {
    const result = {
      filterForButtons: [],
      filterOutButtons: []
    };
    Object.keys(dataValueMap).forEach(groupedByValue => {
      if (!dataValueMap[groupedByValue].shouldHideFilter) {
        result.filterForButtons.push(getFilterForValueButton({
          field: dataValueMap[groupedByValue].fieldName,
          filterManager,
          size: 'xs',
          onClick: () => {},
          onFilterAdded: () => {},
          ownFocus: false,
          showTooltip: true,
          value: [groupedByValue]
        }));
        result.filterOutButtons.push(getFilterOutValueButton({
          field: dataValueMap[groupedByValue].fieldName,
          filterManager,
          size: 'xs',
          onClick: () => {},
          onFilterAdded: () => {},
          ownFocus: false,
          showTooltip: true,
          value: [groupedByValue]
        }));
      }
    });
    return result;
  }, [dataValueMap, filterManager, getFilterForValueButton, getFilterOutValueButton]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    "data-test-subj": LOADING_TEST_ID
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.title
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, Object.keys(dataValueMap).map((groupedByValue, idx) => {
    const value = (data === null || data === void 0 ? void 0 : data[groupedByValue]) || 0;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `percentage-widget--${dataValueMap[groupedByValue].name}`,
      onMouseEnter: () => setHoveredFilter(idx),
      onMouseLeave: () => setHoveredFilter(null),
      "data-test-subj": PERCENT_DATA_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: styles.dataInfo
    }, dataValueMap[groupedByValue].name, hoveredFilter === idx && /*#__PURE__*/_react.default.createElement("div", {
      css: styles.filters
    }, filterButtons.filterForButtons[idx], filterButtons.filterOutButtons[idx]), /*#__PURE__*/_react.default.createElement("span", {
      css: styles.dataValue
    }, value)), /*#__PURE__*/_react.default.createElement("div", {
      css: styles.percentageBackground
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        ...styles.percentageBar,
        width: `${(value / dataValueSum || 0) * 100}%`,
        backgroundColor: dataValueMap[groupedByValue].color
      }
    })));
  })));
};
exports.PercentWidget = PercentWidget;