"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setVersion = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const setVersion = (history, version) => {
  const search = new URLSearchParams(history.location.search);
  if (search.get('_v') === version) return;
  search.set('_v', version);
  const path = history.location.pathname + '?' + search.toString() + (history.location.hash ? '#' + history.location.hash : '');
  history.replace(path);
};
exports.setVersion = setVersion;