"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidatedDualRange = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _is_range_valid = require("./is_range_valid");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Wrapper around EuiDualRange that ensures onChange callback is only called when range value
// is valid and within min/max

class ValidatedDualRange extends _react.Component {
  constructor(...args) {
    super(...args);
    // @ts-ignore state populated by getDerivedStateFromProps
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "_onChange", value => {
      const {
        isValid,
        errorMessage
      } = (0, _is_range_valid.isRangeValid)(value, this.props.min, this.props.max, this.props.allowEmptyRange);
      this.setState({
        value,
        isValid,
        errorMessage
      });
      if (this.props.onChange && isValid) {
        this.props.onChange([value[0], value[1]]);
      }
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.value !== prevState.prevValue) {
      const {
        isValid,
        errorMessage
      } = (0, _is_range_valid.isRangeValid)(nextProps.value, nextProps.min, nextProps.max, nextProps.allowEmptyRange);
      return {
        value: nextProps.value,
        prevValue: nextProps.value,
        isValid,
        errorMessage
      };
    }
    return null;
  }
  render() {
    const {
      compressed,
      fullWidth,
      label,
      formRowDisplay,
      value,
      onChange,
      allowEmptyRange,
      ...rest // TODO: Consider alternatives for spread operator in component
    } = this.props;
    // Ensure the form row is display as compressed if compressed is true
    let evaluatedDisplay = formRowDisplay;
    if (!evaluatedDisplay) {
      evaluatedDisplay = compressed ? 'rowCompressed' : 'row';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: fullWidth,
      isInvalid: !this.state.isValid,
      error: this.state.errorMessage ? [this.state.errorMessage] : [],
      label: label,
      display: evaluatedDisplay
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, (0, _extends2.default)({
      compressed: compressed,
      fullWidth: fullWidth,
      value: this.state.value,
      onChange: this._onChange,
      minInputProps: {
        'aria-label': _i18n.i18n.translate('kibana-react.dualRangeControl.minInputAriaLabel', {
          defaultMessage: 'Range minimum'
        })
      },
      maxInputProps: {
        'aria-label': _i18n.i18n.translate('kibana-react.dualRangeControl.maxInputAriaLabel', {
          defaultMessage: 'Range maximum'
        })
      }
    }, rest)));
  }
}
exports.ValidatedDualRange = ValidatedDualRange;
(0, _defineProperty2.default)(ValidatedDualRange, "defaultProps", {
  allowEmptyRange: true,
  fullWidth: false,
  compressed: false
});