"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplateSolutionNavAvatar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./solution_nav_avatar.scss");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Applies extra styling to a typical EuiAvatar
 */
const KibanaPageTemplateSolutionNavAvatar = ({
  className,
  size,
  ...rest
}) => {
  return (
    /*#__PURE__*/
    // @ts-ignore Complains about ExclusiveUnion between `iconSize` and `iconType`, but works fine
    _react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
      className: (0, _classnames.default)('kbnPageTemplateSolutionNavAvatar', {
        [`kbnPageTemplateSolutionNavAvatar--${size}`]: size
      }, className),
      color: "plain",
      size: size === 'xxl' ? 'xl' : size,
      iconSize: size
    }, rest))
  );
};
exports.KibanaPageTemplateSolutionNavAvatar = KibanaPageTemplateSolutionNavAvatar;