"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _clusters_health = require("./clusters_health");
var _clusters_table = require("./clusters_table");
var _find_clusters = require("./find_clusters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ClustersView extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onSearchChange", ({
      query,
      error
    }) => {
      if (!error) {
        this.setState({
          clusters: (0, _find_clusters.findClusters)(this.props.request, query)
        });
      }
    });
    const clusters = (0, _find_clusters.findClusters)(this.props.request);
    this.state = {
      clusters,
      showSearchAndStatusBar: Object.keys(clusters).length > 1
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.state.showSearchAndStatusBar ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
      box: {
        placeholder: 'Search by cluster name',
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'status',
        name: _i18n.i18n.translate('inspector.requests.clusters.view.statusFilterLabel', {
          defaultMessage: 'Status'
        }),
        multiSelect: 'or',
        options: [{
          value: 'successful',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "successful",
            textProps: {
              size: 'm',
              color: 'text'
            }
          })
        }, {
          value: 'partial',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "partial",
            textProps: {
              size: 'm',
              color: 'text'
            }
          })
        }, {
          value: 'skipped',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "skipped",
            textProps: {
              size: 'm',
              color: 'text'
            }
          })
        }, {
          value: 'failed',
          view: /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
            status: "failed",
            textProps: {
              size: 'm',
              color: 'text'
            }
          })
        }]
      }],
      onChange: this._onSearchChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_clusters_health.ClustersHealth, {
      clusters: this.state.clusters
    })) : null, /*#__PURE__*/_react.default.createElement(_clusters_table.ClustersTable, {
      clusters: this.state.clusters
    }));
  }
}
exports.ClustersView = ClustersView;
(0, _defineProperty2.default)(ClustersView, "shouldShow", request => {
  var _request$response, _request$response$jso, _request$response$jso2, _request$response2, _request$response2$js, _request$response2$js2;
  return Boolean(((_request$response = request.response) === null || _request$response === void 0 ? void 0 : (_request$response$jso = _request$response.json) === null || _request$response$jso === void 0 ? void 0 : (_request$response$jso2 = _request$response$jso.rawResponse) === null || _request$response$jso2 === void 0 ? void 0 : _request$response$jso2._shards) || ((_request$response2 = request.response) === null || _request$response2 === void 0 ? void 0 : (_request$response2$js = _request$response2.json) === null || _request$response2$js === void 0 ? void 0 : (_request$response2$js2 = _request$response2$js.rawResponse) === null || _request$response2$js2 === void 0 ? void 0 : _request$response2$js2._clusters));
});