"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureTable = ShardFailureTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_details = require("./shard_failure_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRowId(failure) {
  return `${failure.shard}${failure.index}`;
}
function ShardFailureTable({
  failures
}) {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const toggleDetails = rowId => {
    const nextExpandedRows = {
      ...expandedRows
    };
    if (rowId in nextExpandedRows) {
      delete nextExpandedRows[rowId];
    } else {
      const shardFailure = failures.find(failure => rowId === getRowId(failure));
      nextExpandedRows[rowId] = shardFailure ? /*#__PURE__*/_react.default.createElement(_shard_failure_details.ShardFailureDetails, {
        failure: shardFailure
      }) : null;
    }
    setExpandedRows(nextExpandedRows);
  };
  const columns = [{
    field: 'shard',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.shardLabel', {
      defaultMessage: 'Shard'
    }),
    render: (shard, item) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(item.rowId),
        "aria-label": item.rowId in expandedRows ? _i18n.i18n.translate('inspector.requests.clusters.shards.table.collapseRow', {
          defaultMessage: 'Collapse table row to hide shard details'
        }) : _i18n.i18n.translate('inspector.requests.clusters.shards.table.expandRow', {
          defaultMessage: 'Expand table row to view shard details'
        }),
        iconType: item.rowId in expandedRows ? 'arrowDown' : 'arrowRight'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, shard));
    },
    width: '20%'
  }, {
    field: 'index',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.indexLabel', {
      defaultMessage: 'Index'
    }),
    render: index => index ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, index) : null
  }, {
    field: 'failureType',
    name: _i18n.i18n.translate('inspector.requests.clusters.shards.table.failureTypeLabel', {
      defaultMessage: 'Failure type'
    }),
    render: failureType => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, failureType)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: failures.map(failure => {
      return {
        rowId: getRowId(failure),
        shard: failure.shard,
        index: failure.index,
        failureType: failure.reason.type
      };
    }),
    isExpandable: true,
    itemIdToExpandedRowMap: expandedRows,
    itemId: "rowId",
    columns: columns
  });
}