"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenShardFailureFlyoutButton = OpenShardFailureFlyoutButton;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_flyout = require("./shard_failure_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function OpenShardFailureFlyoutButton({
  failures
}) {
  const [showFailures, setShowFailures] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, failures.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    onClick: () => {
      setShowFailures(!showFailures);
    },
    size: "xs"
  }, _i18n.i18n.translate('inspector.requests.clusters.shards.openShardFailureFlyoutButtonLabel', {
    defaultMessage: 'View {failedShardCount} failed {failedShardCount, plural, one {shard} other {shards}}',
    values: {
      failedShardCount: failures.length
    }
  })) : null, showFailures ? /*#__PURE__*/_react.default.createElement(_shard_failure_flyout.ShardFailureFlyout, {
    failures: failures,
    onClose: () => {
      setShowFailures(false);
    }
  }) : null);
}