"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropZoneButton = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const moveHereLabel = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dropZoneButton.moveHereToolTip', {
  defaultMessage: 'Move here'
});
const cannotMoveHereLabel = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dropZoneButton.unavailableToolTip', {
  defaultMessage: 'Cannot move here'
});
const DropZoneButton = props => {
  const {
    onClick,
    isDisabled,
    isVisible,
    compressed
  } = props;
  const isUnavailable = isVisible && isDisabled;
  const containerClasses = (0, _classnames.default)({
    'pipelineProcessorsEditor__tree__dropZoneContainer--visible': isVisible,
    'pipelineProcessorsEditor__tree__dropZoneContainer--unavailable': isUnavailable
  });
  const buttonClasses = (0, _classnames.default)({
    'pipelineProcessorsEditor__tree__dropZoneButton--visible': isVisible,
    'pipelineProcessorsEditor__tree__dropZoneButton--compressed': compressed
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `pipelineProcessorsEditor__tree__dropZoneContainer ${containerClasses}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": props['data-test-subj'],
    className: `pipelineProcessorsEditor__tree__dropZoneButton ${buttonClasses}`,
    "aria-label": isUnavailable ? cannotMoveHereLabel : moveHereLabel
    // We artificially disable the button so that hover and pointer events are
    // still enabled
    ,
    onClick: isDisabled ? () => {} : onClick,
    iconType: "empty"
  }));
};
exports.DropZoneButton = DropZoneButton;