"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredHosts = void 0;
var _rxjs = require("rxjs");
var _runtime_types = require("../../../../../common/runtime_types");
var _types = require("../types");
var _constants = require("../constants");
var _utils = require("../utils");
var _query = require("../helpers/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredHosts = async ({
  searchClient,
  sourceConfig,
  params
}) => {
  const query = createQuery(params, sourceConfig);
  return (0, _rxjs.lastValueFrom)((0, _query.runQuery)(searchClient, query, (0, _runtime_types.decodeOrThrow)(_types.FilteredHostsSearchAggregationResponseRT)));
};
exports.getFilteredHosts = getFilteredHosts;
const createQuery = (params, sourceConfig) => {
  var _params$limit;
  (0, _utils.assertQueryStructure)(params.query);
  return {
    allow_no_indices: true,
    ignore_unavailable: true,
    index: sourceConfig.metricAlias,
    body: {
      size: 0,
      query: {
        bool: {
          ...params.query.bool,
          filter: (0, _query.createFilters)({
            params,
            extraFilter: params.query
          })
        }
      },
      aggs: {
        nodes: {
          terms: {
            size: (_params$limit = params.limit) !== null && _params$limit !== void 0 ? _params$limit : _constants.MAX_SIZE,
            field: _constants.BUCKET_KEY,
            order: {
              _key: 'asc'
            }
          }
        }
      }
    }
  };
};