"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountHook = void 0;
var _enzyme = require("enzyme");
var _react = _interopRequireDefault(require("react"));
var _testUtils = require("react-dom/test-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

/**
 * A wrapper object to provide access to the state of a hook under test and to
 * enable interaction with that hook.
 */

/**
 * Allows for execution of hooks inside of a test component which records the
 * returned values.
 *
 * @param body A function that calls the hook and returns data derived from it
 * @param WrapperComponent A component that, if provided, will be wrapped
 * around the test component. This can be useful to provide context values.
 * @return {ReactHookWrapper} An object providing access to the hook state and
 * functions to interact with it.
 */
const mountHook = (body, WrapperComponent, initialArgs = {}) => {
  const hookValueCallback = jest.fn();
  let component;
  const act = actor => {
    (0, _testUtils.act)(() => {
      actor(getLastHookValue(), args => component.setProps(args));
      component.update();
    });
  };
  const getLastHookValue = () => {
    const calls = hookValueCallback.mock.calls;
    if (calls.length <= 0) {
      throw Error('No recent hook value present.');
    }
    return calls[calls.length - 1][0];
  };
  const HookComponent = props => {
    hookValueCallback(body(props));
    return null;
  };
  const TestComponent = args => WrapperComponent ? /*#__PURE__*/_react.default.createElement(WrapperComponent, null, /*#__PURE__*/_react.default.createElement(HookComponent, args)) : /*#__PURE__*/_react.default.createElement(HookComponent, args);
  (0, _testUtils.act)(() => {
    component = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(TestComponent, initialArgs));
  });
  return {
    act,
    component,
    getLastHookValue,
    hookValueCallback
  };
};
exports.mountHook = mountHook;