"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesConfigurationPanel = FeaturesConfigurationPanel;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/advanced-settings-plugin/public");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FeaturesConfigurationPanel({
  readOnly,
  handleFieldChange,
  settingsEditableConfig,
  unsavedChanges
}) {
  const {
    services: {
      docLinks,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "sourceConfigurationFeaturesSectionTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.featuresSectionTitle",
    defaultMessage: "Features"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.LazyField, {
    key: _common.enableInfrastructureHostsView,
    setting: settingsEditableConfig[_common.enableInfrastructureHostsView],
    handleChange: handleFieldChange,
    enableSaving: !readOnly,
    docLinks: docLinks.links,
    toasts: notifications.toasts,
    unsavedChanges: unsavedChanges[_common.enableInfrastructureHostsView]
  }), featureFlags.profilingEnabled && /*#__PURE__*/_react.default.createElement(_public.LazyField, {
    key: _common.enableInfrastructureProfilingIntegration,
    setting: settingsEditableConfig[_common.enableInfrastructureProfilingIntegration],
    handleChange: handleFieldChange,
    enableSaving: !readOnly,
    docLinks: docLinks.links,
    toasts: notifications.toasts,
    unsavedChanges: unsavedChanges[_common.enableInfrastructureProfilingIntegration]
  }));
}