"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useParentBreadcrumbResolver = useParentBreadcrumbResolver;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _translations = require("../../../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useParentBreadcrumbResolver() {
  const hostsLinkProps = (0, _public.useLinkProps)({
    app: 'metrics',
    pathname: 'hosts'
  });
  const inventoryLinkProps = (0, _public.useLinkProps)({
    app: 'metrics',
    pathname: 'inventory'
  });
  const breadcrumbMap = new Map([['/hosts', {
    text: _translations.hostsTitle,
    link: hostsLinkProps
  }], ['/inventory', {
    text: _translations.inventoryTitle,
    link: inventoryLinkProps
  }]]);
  const defaultOption = breadcrumbMap.get('/inventory');
  const {
    state
  } = (0, _reactRouterDom.useLocation)();
  const locationState = state;
  function getOptionsByNodeType(nodeType) {
    if (nodeType === 'host') {
      return breadcrumbMap.get('/hosts');
    }
    return defaultOption;
  }
  function getBreadcrumbOptions(nodeType) {
    if (locationState === undefined) {
      return getOptionsByNodeType(nodeType);
    }
    const originalPathBreadcrumb = locationState.originPathname ? breadcrumbMap.get(locationState.originPathname) : undefined;
    return originalPathBreadcrumb !== null && originalPathBreadcrumb !== void 0 ? originalPathBreadcrumb : defaultOption;
  }
  return {
    getBreadcrumbOptions
  };
}