"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleGroupByControls = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _custom_field_panel = require("./custom_field_panel");
var _dropdown_button = require("../dropdown_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isPopoverOpen: false
};
class WaffleGroupByControls extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", initialState);
    (0, _defineProperty2.default)(this, "handleRemove", field => () => {
      const {
        groupBy
      } = this.props;
      this.props.onChange(groupBy.filter(g => g.field !== field));
      const options = this.props.customOptions.filter(g => g.field !== field);
      this.props.onChangeCustomOptions(options);
      // We need to close the panel after we rmeove the pill icon otherwise
      // it will remain open because the click is still captured by the EuiFilterButton
      setTimeout(() => this.handleClose());
    });
    (0, _defineProperty2.default)(this, "handleClose", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "handleToggle", () => {
      this.setState(state => ({
        isPopoverOpen: !state.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "handleCustomField", field => {
      const options = [...this.props.customOptions, {
        text: field,
        field
      }];
      this.props.onChangeCustomOptions(options);
      const fn = this.handleClick(field);
      fn();
    });
    (0, _defineProperty2.default)(this, "handleClick", field => () => {
      const {
        groupBy
      } = this.props;
      if (groupBy.some(g => g.field === field)) {
        this.handleRemove(field)();
      } else if (this.props.groupBy.length < 2) {
        this.props.onChange([...groupBy, {
          field
        }]);
      }
      this.handleClose();
    });
  }
  render() {
    const {
      nodeType,
      groupBy
    } = this.props;
    const customOptions = this.props.customOptions.map(option => ({
      ...option,
      toolTipContent: option.text
    }));
    const options = this.props.options.concat(customOptions);
    if (!options.length) {
      throw Error(_i18n.i18n.translate('xpack.infra.waffle.unableToSelectGroupErrorMessage', {
        defaultMessage: 'Unable to select group by options for {nodeType}',
        values: {
          nodeType
        }
      }));
    }
    const isMaxGroupingsSelected = groupBy.length >= 2;
    const maxGroupByTooltip = _i18n.i18n.translate('xpack.infra.waffle.maxGroupByTooltip', {
      defaultMessage: 'Only two groupings can be selected at a time'
    });
    const panels = [{
      id: 'firstPanel',
      title: _i18n.i18n.translate('xpack.infra.waffle.selectTwoGroupingsTitle', {
        defaultMessage: 'Select up to two groupings'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.infra.waffle.customGroupByOptionName', {
          defaultMessage: 'Custom field'
        }),
        disabled: isMaxGroupingsSelected,
        toolTipContent: isMaxGroupingsSelected ? maxGroupByTooltip : null,
        icon: 'empty',
        panel: 'customPanel'
      }, ...options.map(o => {
        const icon = groupBy.some(g => g.field === o.field) ? 'check' : 'empty';
        const panel = {
          name: o.text,
          onClick: this.handleClick(o.field),
          icon
        };
        if (o.toolTipContent) {
          panel.toolTipContent = o.toolTipContent;
        }
        if (isMaxGroupingsSelected && icon === 'empty') {
          panel.toolTipContent = maxGroupByTooltip;
          panel.disabled = true;
        }
        return panel;
      })]
    }, {
      id: 'customPanel',
      title: _i18n.i18n.translate('xpack.infra.waffle.customGroupByPanelTitle', {
        defaultMessage: 'Group By Custom Field'
      }),
      width: 685,
      content: /*#__PURE__*/_react.default.createElement(_custom_field_panel.CustomFieldPanel, {
        currentOptions: this.props.customOptions,
        onSubmit: this.handleCustomField,
        fields: this.props.fields
      })
    }];
    const buttonBody = groupBy.length > 0 ? groupBy.map(g => options.find(o => o.field === g.field)).filter(o => o != null)
    // In this map the `o && o.field` is totally unnecessary but Typescript is
    // too stupid to realize that the filter above prevents the next map from being null
    .map(o => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: o && o.field
    }, o && o.text)) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.waffle.groupByAllTitle",
      defaultMessage: "All"
    });
    const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
      label: _i18n.i18n.translate('xpack.infra.waffle.groupByLabel', {
        defaultMessage: 'Group by'
      }),
      onClick: this.handleToggle,
      "data-test-subj": 'waffleGroupByDropdown'
    }, buttonBody);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: this.state.isPopoverOpen,
      id: "groupByPanel",
      button: button,
      panelPaddingSize: "none",
      closePopover: this.handleClose
    }, /*#__PURE__*/_react.default.createElement(StyledContextMenu, {
      initialPanelId: "firstPanel",
      panels: panels,
      "data-test-subj": "groupByContextMenu"
    }));
  }
}
exports.WaffleGroupByControls = WaffleGroupByControls;
(0, _defineProperty2.default)(WaffleGroupByControls, "displayName", 'WaffleGroupByControls');
const StyledContextMenu = (0, _common.euiStyled)(_eui.EuiContextMenu)`
  width: 320px;
  & .euiContextMenuItem__text {
    overflow: hidden;
    text-overflow: ellipsis;
  }
`;