"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupOfNodes = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/kibana-react-plugin/common");
var _group_name = require("./group_name");
var _node = require("./node");
var _use_asset_details_flyout_url_state = require("../../hooks/use_asset_details_flyout_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// custom comparison function for rendering the nodes to prevent unncessary rerendering
const isEqualGroupOfNodes = (prevProps, nextProps) => {
  const {
    bounds: prevBounds,
    group: prevGroup,
    ...prevPropsToCompare
  } = prevProps;
  const {
    bounds: nextBounds,
    group: nextGroup,
    ...nextPropsToCompare
  } = nextProps;
  const {
    nodes: prevNodes,
    ...prevGroupToCompare
  } = prevProps.group;
  const {
    nodes: nextNodes,
    ...nextGroupToCompare
  } = nextProps.group;
  return (0, _lodash.isEqual)(prevPropsToCompare, nextPropsToCompare) && (0, _lodash.isEqual)(prevGroupToCompare, nextGroupToCompare);
};
const GroupOfNodes = /*#__PURE__*/_react.default.memo(({
  group,
  options,
  formatter,
  onDrilldown,
  isChild = false,
  bounds,
  nodeType,
  currentTime,
  detailsItemId
}) => {
  const width = group.width > 200 ? group.width : 200;
  const [_, setFlyoutUrlState] = (0, _use_asset_details_flyout_url_state.useAssetDetailsFlyoutState)();
  return /*#__PURE__*/_react.default.createElement(GroupOfNodesContainer, {
    style: {
      width
    }
  }, /*#__PURE__*/_react.default.createElement(_group_name.GroupName, {
    group: group,
    onDrilldown: onDrilldown,
    isChild: isChild,
    options: options
  }), /*#__PURE__*/_react.default.createElement(Nodes, null, group.width ? group.nodes.map(node => /*#__PURE__*/_react.default.createElement(_node.Node, {
    key: `${node.pathId}:${node.name}`,
    options: options,
    squareSize: group.squareSize,
    node: node,
    formatter: formatter,
    bounds: bounds,
    nodeType: nodeType,
    currentTime: currentTime,
    detailsItemId: detailsItemId,
    setFlyoutUrlState: setFlyoutUrlState
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })));
}, isEqualGroupOfNodes);
exports.GroupOfNodes = GroupOfNodes;
const GroupOfNodesContainer = _common.euiStyled.div`
  margin: 0 10px;
`;
const Nodes = _common.euiStyled.div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${props => props.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;