"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostCountContext = exports.useHostCount = exports.HostCountProvider = exports.HostCount = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/data-plugin/common");
var _react = require("react");
var _rxjs = require("rxjs");
var _constate = _interopRequireDefault(require("constate"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _runtime_types = require("../../../../../common/runtime_types");
var _data_search = require("../../../../utils/data_search");
var _use_data_view = require("./use_data_view");
var _use_unified_search = require("./use_unified_search");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCount = () => {
  const {
    dataView,
    metricAlias
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    buildQuery,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    search: fetchHostCount,
    requests$
  } = (0, _data_search.useDataSearch)({
    getRequest: (0, _react.useCallback)(() => {
      var _dataView$timeFieldNa;
      const query = buildQuery();
      const filters = {
        bool: {
          ...query.bool,
          filter: [...query.bool.filter, {
            exists: {
              field: 'host.name'
            }
          }, {
            range: {
              [(_dataView$timeFieldNa = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '@timestamp']: {
                gte: searchCriteria.dateRange.from,
                lte: searchCriteria.dateRange.to
              }
            }
          }]
        }
      };
      return {
        request: {
          params: {
            allow_no_indices: true,
            ignore_unavailable: true,
            index: metricAlias,
            size: 0,
            track_total_hits: false,
            body: {
              query: filters,
              aggs: {
                count: {
                  cardinality: {
                    field: 'host.name'
                  }
                }
              }
            }
          }
        },
        options: {
          strategy: _common.ES_SEARCH_STRATEGY
        }
      };
    }, [buildQuery, dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName, metricAlias, searchCriteria.dateRange.from, searchCriteria.dateRange.to]),
    parseResponses: (0, _react.useMemo)(() => normalizeDataSearchResponse({
      telemetry,
      telemetryData: {
        withQuery: !!searchCriteria.query.query,
        withFilters: searchCriteria.filters.length > 0 || searchCriteria.panelFilters.length > 0
      }
    }), [searchCriteria.filters.length, searchCriteria.panelFilters.length, searchCriteria.query.query, telemetry])
  });
  const {
    isRequestRunning,
    isResponsePartial,
    latestResponseData,
    latestResponseErrors
  } = (0, _data_search.useLatestPartialDataSearchResponse)(requests$);
  (0, _react.useEffect)(() => {
    fetchHostCount();
  }, [fetchHostCount]);
  return {
    errors: latestResponseErrors,
    isRequestRunning,
    isResponsePartial,
    data: latestResponseData !== null && latestResponseData !== void 0 ? latestResponseData : null
  };
};
exports.useHostCount = useHostCount;
const HostCount = (0, _constate.default)(useHostCount);
exports.HostCount = HostCount;
const [HostCountProvider, useHostCountContext] = HostCount;
exports.useHostCountContext = useHostCountContext;
exports.HostCountProvider = HostCountProvider;
const INITIAL_STATE = {
  data: null,
  errors: [],
  isPartial: true,
  isRunning: true,
  loaded: 0,
  total: undefined
};
const normalizeDataSearchResponse = ({
  telemetry,
  telemetryData
}) => response$ => {
  return response$.pipe((0, _rxjs.map)(response => {
    var _response$isPartial, _response$isRunning;
    return {
      data: (0, _runtime_types.decodeOrThrow)(HostCountResponseRT)(response.rawResponse.aggregations),
      errors: [],
      isPartial: (_response$isPartial = response.isPartial) !== null && _response$isPartial !== void 0 ? _response$isPartial : false,
      isRunning: (_response$isRunning = response.isRunning) !== null && _response$isRunning !== void 0 ? _response$isRunning : false,
      loaded: response.loaded,
      total: response.total
    };
  }), (0, _rxjs.tap)(({
    data
  }) => {
    telemetry.reportHostsViewTotalHostCountRetrieved({
      total: data.count.value,
      with_query: telemetryData.withQuery,
      with_filters: telemetryData.withFilters
    });
  }), (0, _rxjs.startWith)(INITIAL_STATE), (0, _rxjs.catchError)(error => {
    var _error$message;
    return (0, _rxjs.of)({
      ...INITIAL_STATE,
      errors: [(_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : error],
      isRunning: false
    });
  }));
};
const HostCountResponseRT = rt.type({
  count: rt.type({
    value: rt.number
  })
});