"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lens = require("../../../../../../components/lens");
var _chart = require("./chart");
var _popover = require("../../table/popover");
var _use_data_view = require("../../../hooks/use_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsGrid = () => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    value: dashboards
  } = (0, _useAsync.default)(() => {
    return model.metrics.getDashboards();
  });
  const charts = (0, _react.useMemo)(() => {
    var _dashboards$hostsView;
    return (_dashboards$hostsView = dashboards === null || dashboards === void 0 ? void 0 : dashboards.hostsView.get({
      metricsDataView: dataView
    }).charts) !== null && _dashboards$hostsView !== void 0 ? _dashboards$hostsView : [];
  }, [dataView, dashboards]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.infra.metricsGrid.learnMoreAboutMetricsTextLabel', {
    defaultMessage: 'Learn more about metrics'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, null, /*#__PURE__*/_react.default.createElement(_lens.HostMetricsExplanationContent, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    "data-test-subj": "hostsView-metricChart"
  }, charts.map((chartProp, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart.Chart, chartProp)))));
};
exports.MetricsGrid = MetricsGrid;