"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTabBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_alerts_count = require("../../../../../hooks/use_alerts_count");
var _config = require("./config");
var _use_alerts_query = require("../../hooks/use_alerts_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTabBadge = () => {
  const {
    alertsEsQuery
  } = (0, _use_alerts_query.useAlertsQuery)();
  const {
    alertsCount,
    loading,
    error
  } = (0, _use_alerts_count.useAlertsCount)({
    featureIds: _config.infraAlertFeatureIds,
    query: alertsEsQuery
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.countError', {
        defaultMessage: 'The active alert count was not retrieved correctly, try reloading the page.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "warning",
      type: "warning"
    }));
  }
  const shouldRenderBadge = typeof (alertsCount === null || alertsCount === void 0 ? void 0 : alertsCount.activeAlertCount) === 'number' && alertsCount.activeAlertCount > 0;
  return shouldRenderBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    className: "eui-alignCenter",
    size: "m",
    "data-test-subj": "hostsView-tabs-alerts-count"
  }, alertsCount === null || alertsCount === void 0 ? void 0 : alertsCount.activeAlertCount) : null;
};
exports.AlertsTabBadge = AlertsTabBadge;