"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogViewErrorPage = exports.LogSourceErrorPage = exports.ConnectedLogViewErrorPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@xstate/react");
var _public2 = require("@kbn/logs-shared-plugin/public");
var _common2 = require("@kbn/logs-shared-plugin/common");
var _page_template = require("./page_template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogViewErrorPage = ({
  errors,
  onRetry
}) => {
  const settingsLinkProps = (0, _public.useLinkProps)({
    app: 'logs',
    pathname: '/settings'
  });
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, {
    isEmptyState: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.failedToLoadSourceTitle",
      defaultMessage: "Failed to load configuration"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.failedToLoadSourceMessage",
      defaultMessage: "Errors occurred while attempting to load the configuration. Try again or change the configuration to fix the problem."
    })), errors.map(error => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: error.name
    }, /*#__PURE__*/_react.default.createElement(LogSourceErrorMessage, {
      error: error
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraLogViewErrorPageTryAgainButton",
      onClick: onRetry,
      iconType: "refresh",
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.tryAgainButtonLabel",
      defaultMessage: "Try again"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "infraLogViewErrorPageChangeConfigurationButton",
      iconType: "gear"
    }, settingsLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.navigateToSettingsButtonLabel",
      defaultMessage: "Change configuration"
    }))]
  }));
};
exports.LogViewErrorPage = LogViewErrorPage;
const LogSourceErrorPage = LogViewErrorPage;
exports.LogSourceErrorPage = LogSourceErrorPage;
const ConnectedLogViewErrorPage = () => {
  const {
    logViewStateService
  } = (0, _public2.useLogViewContext)();
  const errors = (0, _react2.useSelector)(logViewStateService, state => {
    return state.matches('loadingFailed') || state.matches('resolutionFailed') || state.matches('checkingStatusFailed') ? [state.context.error] : [];
  });
  const retry = (0, _react.useCallback)(() => {
    logViewStateService.send({
      type: 'RETRY'
    });
  }, [logViewStateService]);
  return /*#__PURE__*/_react.default.createElement(LogSourceErrorPage, {
    errors: errors,
    onRetry: retry
  });
};
exports.ConnectedLogViewErrorPage = ConnectedLogViewErrorPage;
const LogSourceErrorMessage = ({
  error
}) => {
  if (error instanceof _common2.ResolveLogViewError) {
    var _error$cause$message, _error$cause;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.resolveLogSourceConfigurationErrorTitle",
        defaultMessage: "Failed to resolve the log source configuration"
      })
    }, error.cause instanceof _common.SavedObjectNotFound ?
    /*#__PURE__*/
    // the SavedObjectNotFound error message contains broken markup
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.savedObjectNotFoundErrorMessage",
      defaultMessage: "Failed to locate that {savedObjectType}: {savedObjectId}",
      values: {
        savedObjectType: error.cause.savedObjectType,
        savedObjectId: error.cause.savedObjectId
      }
    }) : `${(_error$cause$message = (_error$cause = error.cause) === null || _error$cause === void 0 ? void 0 : _error$cause.message) !== null && _error$cause$message !== void 0 ? _error$cause$message : error.message}`);
  } else if (error instanceof _common2.FetchLogViewError) {
    var _error$cause$message2, _error$cause2;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.fetchLogSourceConfigurationErrorTitle",
        defaultMessage: "Failed to load the log source configuration"
      })
    }, `${(_error$cause$message2 = (_error$cause2 = error.cause) === null || _error$cause2 === void 0 ? void 0 : _error$cause2.message) !== null && _error$cause$message2 !== void 0 ? _error$cause$message2 : error.message}`);
  } else if (error instanceof _common2.FetchLogViewStatusError) {
    var _error$cause$message3, _error$cause3;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.fetchLogSourceStatusErrorTitle",
        defaultMessage: "Failed to determine the status of the log source"
      })
    }, `${(_error$cause$message3 = (_error$cause3 = error.cause) === null || _error$cause3 === void 0 ? void 0 : _error$cause3.message) !== null && _error$cause$message3 !== void 0 ? _error$cause$message3 : error.message}`);
  } else {
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: error.name
    }, `${error.message}`);
  }
};
const LogSourceErrorCallout = ({
  title,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  className: "eui-textLeft",
  color: "danger",
  iconType: "warning",
  title: title
}, /*#__PURE__*/_react.default.createElement("p", null, children));