"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSourceProvider = exports.useSourceContext = exports.useSource = exports.pickIndexPattern = exports.SourceProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_tracked_promise = require("../../utils/use_tracked_promise");
var _source_errors = require("./source_errors");
var _notifications = require("./notifications");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pickIndexPattern = (source, type) => {
  if (!source) {
    return 'unknown-index';
  }
  if (type === 'metrics') {
    return source.configuration.metricAlias;
  }
  return `${source.configuration.metricAlias}`;
};
exports.pickIndexPattern = pickIndexPattern;
const useSource = ({
  sourceId
}) => {
  var _source$status;
  const {
    services
  } = (0, _public.useKibana)();
  const notify = (0, _notifications.useSourceNotifier)();
  const fetchService = services.http;
  const API_URL = `/api/metrics/source/${sourceId}`;
  const [source, setSource] = (0, _react.useState)(undefined);
  const [loadSourceRequest, loadSource] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: () => {
      if (!fetchService) {
        throw new _source_errors.MissingHttpClientException();
      }
      return fetchService.fetch(API_URL, {
        method: 'GET'
      });
    },
    onResolve: response => {
      if (response) {
        setSource(response.source);
      }
    }
  }, [fetchService, sourceId]);
  const [createSourceConfigurationRequest, createSourceConfiguration] = (0, _use_tracked_promise.useTrackedPromise)({
    createPromise: async sourceProperties => {
      if (!fetchService) {
        throw new _source_errors.MissingHttpClientException();
      }
      return await fetchService.patch(API_URL, {
        method: 'PATCH',
        body: JSON.stringify(sourceProperties)
      });
    },
    onResolve: response => {
      if (response) {
        notify.updateSuccess();
        setSource(response.source);
      }
    },
    onReject: error => {
      var _body;
      notify.updateFailure((_body = error.body) === null || _body === void 0 ? void 0 : _body.message);
    }
  }, [fetchService, sourceId]);
  (0, _react.useEffect)(() => {
    loadSource();
  }, [loadSource, sourceId]);
  const createDerivedIndexPattern = () => {
    return {
      fields: source !== null && source !== void 0 && source.status ? source.status.indexFields : [],
      title: pickIndexPattern(source, 'metrics')
    };
  };
  const hasFailedLoadingSource = loadSourceRequest.state === 'rejected';
  const isUninitialized = loadSourceRequest.state === 'uninitialized';
  const isLoadingSource = loadSourceRequest.state === 'pending';
  const isLoading = isLoadingSource || createSourceConfigurationRequest.state === 'pending';
  const sourceExists = source ? !!source.version : undefined;
  const metricIndicesExist = Boolean(source === null || source === void 0 ? void 0 : (_source$status = source.status) === null || _source$status === void 0 ? void 0 : _source$status.metricIndicesExist);
  const version = source === null || source === void 0 ? void 0 : source.version;
  return {
    createSourceConfiguration,
    createDerivedIndexPattern,
    isLoading,
    isLoadingSource,
    isUninitialized,
    hasFailedLoadingSource,
    loadSource,
    loadSourceRequest,
    loadSourceFailureMessage: hasFailedLoadingSource ? `${loadSourceRequest.value}` : undefined,
    metricIndicesExist,
    source,
    sourceExists,
    sourceId,
    updateSourceConfiguration: createSourceConfiguration,
    version
  };
};
exports.useSource = useSource;
const [SourceProvider, useSourceContext] = (0, _constate.default)(useSource);
exports.useSourceContext = useSourceContext;
exports.SourceProvider = SourceProvider;
const withSourceProvider = Component => (sourceId = 'default') => {
  return function ComponentWithSourceProvider(props) {
    return /*#__PURE__*/_react.default.createElement(SourceProvider, {
      sourceId: sourceId
    }, /*#__PURE__*/_react.default.createElement(Component, props));
  };
};
exports.withSourceProvider = withSourceProvider;