"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _use_kibana = require("../../../hooks/use_kibana");
var _loading = require("../../loading");
var _constants = require("../constants");
var _content = require("../content/content");
var _flyout_header = require("../header/flyout_header");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _use_asset_details_url_state = require("../hooks/use_asset_details_url_state");
var _use_page_header = require("../hooks/use_page_header");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Flyout = ({
  tabs = [],
  links = [],
  closeFlyout
}) => {
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    asset,
    loading
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    rightSideItems,
    tabEntries
  } = (0, _use_page_header.usePageHeader)(tabs, links);
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _useEffectOnce.default)(() => {
    telemetry.reportAssetDetailsFlyoutViewed({
      componentName: _constants.ASSET_DETAILS_FLYOUT_COMPONENT_NAME,
      assetType: asset.type,
      tabId: activeTabId
    });
  });
  const handleOnClose = (0, _react.useCallback)(() => {
    setUrlState(null);
    closeFlyout();
  }, [closeFlyout, setUrlState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleOnClose,
    ownFocus: false,
    "data-component-name": _constants.ASSET_DETAILS_FLYOUT_COMPONENT_NAME,
    "data-asset-type": asset.type
  }, loading ? /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
    height: "100%",
    width: "auto",
    text: _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
      defaultMessage: 'Loading data'
    })
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    title: asset.name,
    tabs: tabEntries,
    rightSideItems: rightSideItems
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_content.Content, null))));
};
exports.Flyout = Flyout;