"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Profiling = Profiling;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _flamegraph = require("./flamegraph");
var _functions = require("./functions");
var _date_picker = require("../../date_picker/date_picker");
var _use_profiling_status_data = require("../../hooks/use_profiling_status_data");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _types = require("../../types");
var _error_prompt = require("./error_prompt");
var _description_callout = require("./description_callout");
var _popover = require("../common/popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Profiling() {
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    error,
    loading,
    response
  } = (0, _use_profiling_status_data.useProfilingStatusData)({
    isActive: activeTabId === _types.ContentTabIds.PROFILING
  });
  const tabs = [{
    id: 'flamegraph',
    name: _i18n.i18n.translate('xpack.infra.profiling.flamegraphTabName', {
      defaultMessage: 'Flamegraph'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_flamegraph.Flamegraph, null)),
    append: /*#__PURE__*/_react.default.createElement(_popover.Popover, {
      iconSize: "s",
      iconColor: "subdued",
      icon: "questionInCircle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.profiling.flamegraphInfoPopoverBody",
      defaultMessage: "See a visual representation of the functions that consume the most resources. Each rectangle represents a function. The rectangle width represents the time spent in the function, and the number of stacked rectangles represents the number of functions called to reach the current function. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProfilingFlamegraphTabLearnMoreLink",
          href: "https://www.elastic.co/guide/en/observability/current/universal-profiling.html#profiling-flamegraphs-intro",
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.infra.profiling.flamegraphTabLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      }
    })))
  }, {
    id: 'functions',
    name: _i18n.i18n.translate('xpack.infra.tabs.profiling.functionsTabName', {
      defaultMessage: 'Top 10 Functions'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_functions.Functions, null)),
    append: /*#__PURE__*/_react.default.createElement(_popover.Popover, {
      iconSize: "s",
      iconColor: "subdued",
      icon: "questionInCircle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.profiling.functionsInfoPopoverBody",
      defaultMessage: "Identify the most expensive lines of code on your host by looking at the most frequently sampled functions, broken down by CPU time, annualized CO2, and annualized cost estimates. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProfilingFunctionsTabLearnMoreLink",
          href: "https://www.elastic.co/guide/en/observability/current/universal-profiling.html#profiling-functions-intro",
          external: true,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.infra.profiling.functionsTabLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      }
    })))
  }];
  if (loading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          display: flex;
          justify-content: center;
        `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }));
  }
  if (error !== null) {
    return /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (response === null || response === void 0 ? void 0 : response.has_setup) === false ? /*#__PURE__*/_react.default.createElement(_public.ProfilingEmptyState, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, null), /*#__PURE__*/_react.default.createElement(_description_callout.DescriptionCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0]
  })));
}