"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessRowCharts = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/charts-plugin/public");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _calculate_domain = require("../../../../pages/metrics/metrics_explorer/components/helpers/calculate_domain");
var _use_process_list_row_chart = require("../../hooks/use_process_list_row_chart");
var _use_timeline_chart_theme = require("../../../../utils/use_timeline_chart_theme");
var _series_chart = require("../../../../pages/metrics/metrics_explorer/components/series_chart");
var _color_palette = require("../../../../../common/color_palette");
var _formatters = require("../../../../../common/formatters");
var _types = require("../../../../../common/metrics_explorer_views/types");
var _use_request_observable = require("../../hooks/use_request_observable");
var _metric_not_available_explanation = require("../../components/metric_not_available_explanation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyChartPlaceholder = ({
  metricName
}) => /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
  css: (0, _react2.css)`
       {
        height: 140px;
      }
    `,
  icon: _chartIcons.IconChartLine,
  message: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.nodeDetails.processes.charts.noDataLabel",
    defaultMessage: "No results found"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: metricName
  })))
});
const ProcessRowCharts = ({
  command,
  hasCpuData,
  hasMemoryData
}) => {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    loading,
    error,
    response
  } = (0, _use_process_list_row_chart.useProcessListRowChart)(command, request$);
  const isLoading = loading || !response;
  const cpuChart = error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, failedToLoadChart)
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null) : hasCpuData ? /*#__PURE__*/_react.default.createElement(ProcessChart, {
    timeseries: response.cpu,
    color: _color_palette.Color.color2,
    label: cpuMetricLabel
  }) : /*#__PURE__*/_react.default.createElement(EmptyChartPlaceholder, {
    metricName: cpuMetricLabel
  });
  const memoryChart = error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, failedToLoadChart)
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null) : hasMemoryData ? /*#__PURE__*/_react.default.createElement(ProcessChart, {
    timeseries: response.memory,
    color: _color_palette.Color.color0,
    label: memoryMetricLabel
  }) : /*#__PURE__*/_react.default.createElement(EmptyChartPlaceholder, {
    metricName: memory
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, cpuMetricLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, cpuChart)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, memoryMetricLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, memoryChart)));
};
exports.ProcessRowCharts = ProcessRowCharts;
const ProcessChart = ({
  timeseries,
  color,
  label
}) => {
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const chartMetric = {
    color,
    aggregation: 'avg',
    label
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    var _first, _last;
    if (!timeseries) return () => '';
    const firstTimestamp = (_first = (0, _lodash.first)(timeseries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(timeseries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [timeseries]);
  const yAxisFormatter = (0, _formatters.createFormatter)('percent');
  const dataDomain = (0, _calculate_domain.calculateDomain)(timeseries, [chartMetric], false);
  const domain = dataDomain ? {
    max: dataDomain.max * 1.1,
    // add 10% headroom.
    min: dataDomain.min
  } : {
    max: 0,
    min: 0
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
         {
          width: 100%;
          height: 140px;
        }
      `
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _types.MetricsExplorerChartType.area,
    metric: chartMetric,
    id: "0",
    series: timeseries,
    stack: false
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: domain,
    ticks: 6,
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss.SSS')
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartTheme.baseTheme,
    theme: chartTheme.theme,
    locale: _i18n.i18n.getLocale()
  })));
};
const cpuMetricLabel = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCPU', {
  defaultMessage: 'CPU'
});
const memoryMetricLabel = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelMemory', {
  defaultMessage: 'Memory'
});
const memory = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowMemory', {
  defaultMessage: 'memory'
});
const failedToLoadChart = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.failedToLoadChart', {
  defaultMessage: 'Unable to load chart'
});