"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/visualizations/constants");
var _build = require("../../../../../utils/filters/build");
var _lens = require("../../../../lens");
var _use_date_picker = require("../../../hooks/use_date_picker");
var _chart_utils = require("./chart_utils");
var _use_loading_state = require("../../../hooks/use_loading_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Chart = ({
  id,
  filterFieldName,
  dataViewOrigin,
  overrides,
  dateRange,
  assetName,
  dataView,
  ...props
}) => {
  const {
    setDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    searchSessionId
  } = (0, _use_loading_state.useLoadingStateContext)();
  const {
    ['data-test-subj']: dataTestSubj,
    ...chartProps
  } = {
    ...props
  };
  const filters = (0, _react.useMemo)(() => {
    return [(0, _build.buildCombinedHostsFilter)({
      field: filterFieldName,
      values: [assetName],
      dataView
    })];
  }, [assetName, dataView, filterFieldName]);
  const handleBrushEnd = (0, _react.useCallback)(({
    range,
    preventDefault
  }) => {
    setDateRange({
      from: new Date(range[0]).toISOString(),
      to: new Date(range[1]).toISOString()
    });
    preventDefault();
  }, [setDateRange]);
  const handleFilter = (0, _react.useCallback)(event => {
    const range = (0, _chart_utils.extractRangeFromChartFilterEvent)(event);
    if (range === null) {
      return;
    }
    setDateRange(range);
    event.preventDefault();
  }, [setDateRange]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, (0, _extends2.default)({}, chartProps, {
    id: `${dataTestSubj}${id}`,
    borderRadius: "m",
    dataView: dataView,
    dateRange: dateRange,
    height: _constants.METRIC_CHART_HEIGHT,
    searchSessionId: searchSessionId,
    filters: filters,
    overrides: overrides,
    onBrushEnd: handleBrushEnd,
    onFilter: handleFilter
  }));
};
exports.Chart = Chart;