"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingStatusData = useProfilingStatusData;
var _react = require("react");
var _use_http_request = require("../../../hooks/use_http_request");
var _use_request_observable = require("./use_request_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingStatusData({
  isActive
}) {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    loading,
    error,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)(`/api/infra/profiling/status`, 'GET', undefined, undefined, undefined, undefined, true);
  (0, _react.useEffect)(() => {
    if (!isActive) {
      return;
    }
    request$.next(makeRequest);
  }, [isActive, makeRequest, request$]);
  return {
    loading,
    error,
    response
  };
}