"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsEmbeddable = exports.ASSET_DETAILS_EMBEDDABLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _common_providers = require("../../apps/common_providers");
var _lazy_asset_details_wrapper = require("./lazy_asset_details_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_DETAILS_EMBEDDABLE = 'ASSET_DETAILS_EMBEDDABLE';
exports.ASSET_DETAILS_EMBEDDABLE = ASSET_DETAILS_EMBEDDABLE;
class AssetDetailsEmbeddable extends _public.Embeddable {
  constructor(core, pluginDeps, pluginStart, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", ASSET_DETAILS_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.core = core;
    this.pluginDeps = pluginDeps;
    this.pluginStart = pluginStart;
    this.subscription = this.getInput$().subscribe(() => this.renderComponent());
  }
  render(node) {
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
    this.node = node;
    this.renderComponent();
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  async reload() {}
  renderComponent() {
    if (!this.node) {
      return;
    }
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
      core: this.core,
      plugins: this.pluginDeps,
      pluginStart: this.pluginStart,
      theme$: this.core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_lazy_asset_details_wrapper.LazyAssetDetailsWrapper, {
      assetId: this.input.assetId,
      assetName: this.input.assetName,
      assetType: this.input.assetType,
      dateRange: this.input.dateRange,
      overrides: this.input.overrides,
      renderMode: this.input.renderMode,
      tabs: this.input.tabs,
      links: this.input.links,
      metricAlias: this.input.metricAlias
    })))), this.node);
  }
}
exports.AssetDetailsEmbeddable = AssetDetailsEmbeddable;