"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.METRICS_APP_DATA_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
require("../index.scss");
var _link_to_metrics = require("../pages/link_to/link_to_metrics");
var _metrics = require("../pages/metrics");
var _redirect_with_query_params = require("../utils/redirect_with_query_params");
var _common_providers = require("./common_providers");
var _common_styles = require("./common_styles");
var _metrics_source = require("../containers/metrics_source");
var _plugin_config_context = require("../containers/plugin_config_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_APP_DATA_TEST_SUBJ = 'infraMetricsPage';
exports.METRICS_APP_DATA_TEST_SUBJ = METRICS_APP_DATA_TEST_SUBJ;
const renderApp = (core, plugins, pluginStart, pluginConfig, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}) => {
  const storage = new _public.Storage(window.localStorage);
  (0, _common_styles.prepareMountElement)(element, METRICS_APP_DATA_TEST_SUBJ);
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(MetricsApp, {
    core: core,
    history: history,
    plugins: plugins,
    pluginStart: pluginStart,
    pluginConfig: pluginConfig,
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$
  }), element);
  return () => {
    plugins.data.search.session.clear();
    core.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const MetricsApp = ({
  core,
  history,
  pluginStart,
  pluginConfig,
  plugins,
  setHeaderActionMenu,
  storage,
  theme$
}) => {
  var _uiCapabilities$infra, _uiCapabilities$infra2, _uiCapabilities$infra3, _uiCapabilities$infra4;
  const uiCapabilities = core.application.capabilities;
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
    core: core,
    pluginStart: pluginStart,
    plugins: plugins,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common_providers.CommonInfraProviders, {
    appName: "Metrics UI",
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    triggersActionsUI: plugins.triggersActionsUi,
    observabilityAIAssistant: plugins.observabilityAIAssistant
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: "default"
  }, /*#__PURE__*/_react.default.createElement(_plugin_config_context.PluginConfigProvider, {
    value: pluginConfig
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/link-to",
    component: _link_to_metrics.LinkToMetricsPage
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.show) && /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/",
    exact: true,
    to: "/inventory"
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra2 = uiCapabilities.infrastructure) === null || _uiCapabilities$infra2 === void 0 ? void 0 : _uiCapabilities$infra2.show) && /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/snapshot",
    exact: true,
    to: "/inventory"
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra3 = uiCapabilities.infrastructure) === null || _uiCapabilities$infra3 === void 0 ? void 0 : _uiCapabilities$infra3.show) && /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/metrics-explorer",
    exact: true,
    to: "/explorer"
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra4 = uiCapabilities.infrastructure) === null || _uiCapabilities$infra4 === void 0 ? void 0 : _uiCapabilities$infra4.show) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _metrics.InfrastructurePage
  })))))));
};