"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logIndexReferenceRT = exports.logIndexPatternReferenceRT = exports.logIndexNameReferenceRT = exports.StaticSourceConfigurationRuntimeType = exports.SourceStatusRuntimeType = exports.SourceRuntimeType = exports.SourceResponseRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationRuntimeType = exports.SourceConfigurationRT = exports.SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = exports.SavedSourceConfigurationRuntimeType = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These are the core source configuration types that represent a Source Configuration in
 * it's entirety. There are then subsets of this configuration that form the Logs Source Configuration
 * and Metrics Source Configuration. The Logs Source Configuration is further expanded to it's resolved form.
 * -> Source Configuration
 *  -> Logs source configuration
 *    -> Resolved Logs Source Configuration
 *  -> Metrics Source Configuration
 */

/* eslint-disable @typescript-eslint/no-empty-interface */

/**
 * Log columns
 */

const SourceConfigurationTimestampColumnRuntimeType = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationTimestampColumnRuntimeType = SourceConfigurationTimestampColumnRuntimeType;
const SourceConfigurationMessageColumnRuntimeType = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationMessageColumnRuntimeType = SourceConfigurationMessageColumnRuntimeType;
const SourceConfigurationFieldColumnRuntimeType = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
exports.SourceConfigurationFieldColumnRuntimeType = SourceConfigurationFieldColumnRuntimeType;
const SourceConfigurationColumnRuntimeType = rt.union([SourceConfigurationTimestampColumnRuntimeType, SourceConfigurationMessageColumnRuntimeType, SourceConfigurationFieldColumnRuntimeType]);
exports.SourceConfigurationColumnRuntimeType = SourceConfigurationColumnRuntimeType;
/**
 * Log indices
 */

// Kibana index pattern
const logIndexPatternReferenceRT = rt.type({
  type: rt.literal('index_pattern'),
  indexPatternId: rt.string
});
exports.logIndexPatternReferenceRT = logIndexPatternReferenceRT;
// Legacy support
const logIndexNameReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
exports.logIndexNameReferenceRT = logIndexNameReferenceRT;
const logIndexReferenceRT = rt.union([logIndexPatternReferenceRT, logIndexNameReferenceRT]);
exports.logIndexReferenceRT = logIndexReferenceRT;
const SourceConfigurationRT = rt.type({
  name: rt.string,
  description: rt.string,
  metricAlias: rt.string,
  logIndices: logIndexReferenceRT,
  inventoryDefaultView: rt.string,
  metricsExplorerDefaultView: rt.string,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType),
  anomalyThreshold: rt.number
});

/**
 * Stored source configuration as read from and written to saved objects
 */
exports.SourceConfigurationRT = SourceConfigurationRT;
const SavedSourceConfigurationRuntimeType = rt.partial(SourceConfigurationRT.props);
exports.SavedSourceConfigurationRuntimeType = SavedSourceConfigurationRuntimeType;
/**
 * Static source configuration, the result of merging values from the config file and
 * hardcoded defaults.
 */

const StaticSourceConfigurationRuntimeType = rt.partial({
  ...SourceConfigurationRT.props
});
exports.StaticSourceConfigurationRuntimeType = StaticSourceConfigurationRuntimeType;
/**
 * Full source configuration type after all cleanup has been done at the edges
 */

const SourceConfigurationRuntimeType = rt.type({
  ...SourceConfigurationRT.props,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType)
});
exports.SourceConfigurationRuntimeType = SourceConfigurationRuntimeType;
/**
 * Source status
 */
const SourceStatusFieldRuntimeType = rt.type({
  name: rt.string,
  type: rt.string,
  searchable: rt.boolean,
  aggregatable: rt.boolean,
  displayable: rt.boolean
});
const SourceStatusRuntimeType = rt.type({
  logIndicesExist: rt.boolean,
  metricIndicesExist: rt.boolean,
  remoteClustersExist: rt.boolean,
  indexFields: rt.array(SourceStatusFieldRuntimeType)
});
exports.SourceStatusRuntimeType = SourceStatusRuntimeType;
/**
 * Source configuration along with source status and metadata
 */
const SourceRuntimeType = rt.intersection([rt.type({
  id: rt.string,
  origin: rt.keyof({
    fallback: null,
    internal: null,
    stored: null
  }),
  configuration: SourceConfigurationRuntimeType
}), rt.partial({
  version: rt.string,
  updatedAt: rt.number,
  status: SourceStatusRuntimeType
})]);
exports.SourceRuntimeType = SourceRuntimeType;
const SourceResponseRuntimeType = rt.type({
  source: SourceRuntimeType
});
exports.SourceResponseRuntimeType = SourceResponseRuntimeType;