"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadIndicesSuccess = exports.loadIndicesStart = exports.loadIndicesError = exports.loadIndices = void 0;
var _reduxActions = require("redux-actions");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadIndicesStart = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_LOAD_INDICES_START');
exports.loadIndicesStart = loadIndicesStart;
const loadIndicesSuccess = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_LOAD_INDICES_SUCCESS');
exports.loadIndicesSuccess = loadIndicesSuccess;
const loadIndicesError = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_LOAD_INDICES_ERROR');
exports.loadIndicesError = loadIndicesError;
const loadIndices = () => async dispatch => {
  dispatch(loadIndicesStart());
  let indices;
  try {
    indices = await (0, _services.loadIndices)();
  } catch (error) {
    return dispatch(loadIndicesError(error));
  }
  dispatch(loadIndicesSuccess({
    indices
  }));
};
exports.loadIndices = loadIndices;