"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AliasesDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _overview_card = require("./overview_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_VISIBLE_ALIASES = 3;
const AliasesDetails = ({
  aliases
}) => {
  const [isShowingAliases, setIsShowingAliases] = (0, _react.useState)(false);
  if (!Array.isArray(aliases)) {
    return null;
  }
  const aliasesBadges = aliases.slice(0, MAX_VISIBLE_ALIASES).map(alias => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: (0, _react2.css)`
        max-width: 250px;
      `
  }, alias));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    "data-test-subj": "indexDetailsAliases",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.cardTitle', {
      defaultMessage: 'Aliases'
    }),
    content: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "baseline"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: (0, _react2.css)`
                    font-size: ${_uiTheme.euiThemeVars.euiFontSizeL};
                  `
      }, aliases.length)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.aliasesCountLabel', {
        defaultMessage: '{aliases, plural, one {Alias} other {Aliases}}',
        values: {
          aliases: aliases.length
        }
      })))),
      right: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        onClick: () => {
          setIsShowingAliases(true);
        }
      }, "View all aliases")
    },
    footer: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        gutterSize: "s"
      }, aliasesBadges, aliases.length > MAX_VISIBLE_ALIASES && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, "+", aliases.length - MAX_VISIBLE_ALIASES))
    }
  }), isShowingAliases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: () => setIsShowingAliases(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.cardTitle', {
    defaultMessage: 'Aliases'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    maxWidth: false
  }, aliases.map(alias => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    wrapText: true,
    key: alias,
    label: alias
  }))))));
};
exports.AliasesDetails = AliasesDetails;