"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFieldsTreeEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mappings_state_context = require("../../mappings_state_context");
var _fields = require("./fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentFieldsTreeEditor = () => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fields: {
      byId,
      rootLevelFields
    },
    documentFields: {
      status,
      fieldToAddFieldTo
    }
  } = (0, _mappings_state_context.useMappingsState)();
  const getField = (0, _react.useCallback)(fieldId => byId[fieldId], [byId]);
  const fields = (0, _react.useMemo)(() => rootLevelFields.map(getField), [rootLevelFields, getField]);
  const addField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.createField'
    });
  }, [dispatch]);
  const renderCreateField = () => {
    // The "fieldToAddFieldTo" is undefined when adding to the top level "properties" object.
    const isCreateFieldFormVisible = status === 'creatingField' && fieldToAddFieldTo === undefined;
    if (!isCreateFieldFormVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_fields.CreateField, {
      isCancelable: fields.length > 0,
      allFields: byId,
      isRootLevelField: true
    });
  };
  const renderAddFieldButton = () => {
    const isDisabled = status !== 'idle';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      disabled: isDisabled,
      onClick: addField,
      iconType: "plusInCircleFilled",
      "data-test-subj": "addFieldButton"
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addFieldButtonLabel', {
      defaultMessage: 'Add field'
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_fields.FieldsList, {
    fields: fields
  }), renderCreateField(), renderAddFieldButton());
};
exports.DocumentFieldsTreeEditor = DocumentFieldsTreeEditor;