"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _mappings_state_context = require("../../../mappings_state_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  validations,
  ...rest
} = _constants.PARAMETERS_DEFINITION.name.fieldConfig;
const NameParameter = () => {
  const {
    fields: {
      rootLevelFields,
      byId
    },
    documentFields: {
      fieldToAddFieldTo,
      fieldToEdit
    }
  } = (0, _mappings_state_context.useMappingsState)();
  const initialName = fieldToEdit ? byId[fieldToEdit].source.name : undefined;
  const parentId = fieldToEdit ? byId[fieldToEdit].parentId : fieldToAddFieldTo;
  const uniqueNameValidator = (0, _react.useCallback)(arg => {
    return (0, _lib.validateUniqueName)({
      rootLevelFields,
      byId
    }, initialName, parentId)(arg);
  }, [rootLevelFields, byId, initialName, parentId]);
  const nameConfig = (0, _react.useMemo)(() => ({
    ...rest,
    validations: [...validations, {
      validator: uniqueNameValidator
    }]
  }), [uniqueNameValidator]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: nameConfig,
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'nameParameterInput'
      }
    }
  });
};
exports.NameParameter = NameParameter;