"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeMigrateAndAllocateActions = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serializeMigrateAndAllocateActions = ({
  dataTierAllocationType,
  allocationNodeAttribute
},
/**
 * The new configuration merged with old configuration to ensure we don't lose
 * any fields.
 */
mergedActions = {},
/**
 * The actions from the policy for a given phase when it was loaded.
 */
originalActions = {}, numberOfReplicas) => {
  var _originalActions$allo, _originalActions$allo3;
  const {
    allocate,
    migrate,
    ...otherActions
  } = mergedActions;

  // First copy over all non-allocate and migrate actions.
  const actions = {
    ...otherActions
  };

  // The UI only knows about include, exclude, require and number_of_replicas so copy over all other values.
  if (allocate) {
    const {
      include,
      exclude,
      require,
      number_of_replicas: __,
      ...otherSettings
    } = allocate;
    if (!(0, _lodash.isEmpty)(otherSettings)) {
      actions.allocate = {
        ...otherSettings
      };
    }
  }
  switch (dataTierAllocationType) {
    case 'node_attrs':
      if (allocationNodeAttribute) {
        const [name, value] = allocationNodeAttribute.split(':');
        actions.allocate = {
          // copy over any other allocate details like "number_of_replicas"
          ...actions.allocate,
          require: {
            [name]: value
          }
        };
      } else {
        // The form has been configured to use node attribute based allocation but no node attribute
        // was selected. We fall back to what was originally selected in this case. This might be
        // migrate.enabled: "false"
        actions.migrate = originalActions.migrate;
      }

      // copy over the original include and exclude values until we can set them in the form.
      if (!(0, _lodash.isEmpty)(originalActions === null || originalActions === void 0 ? void 0 : (_originalActions$allo = originalActions.allocate) === null || _originalActions$allo === void 0 ? void 0 : _originalActions$allo.include)) {
        var _originalActions$allo2;
        actions.allocate = {
          ...actions.allocate,
          include: {
            ...(originalActions === null || originalActions === void 0 ? void 0 : (_originalActions$allo2 = originalActions.allocate) === null || _originalActions$allo2 === void 0 ? void 0 : _originalActions$allo2.include)
          }
        };
      }
      if (!(0, _lodash.isEmpty)(originalActions === null || originalActions === void 0 ? void 0 : (_originalActions$allo3 = originalActions.allocate) === null || _originalActions$allo3 === void 0 ? void 0 : _originalActions$allo3.exclude)) {
        var _originalActions$allo4;
        actions.allocate = {
          ...actions.allocate,
          exclude: {
            ...(originalActions === null || originalActions === void 0 ? void 0 : (_originalActions$allo4 = originalActions.allocate) === null || _originalActions$allo4 === void 0 ? void 0 : _originalActions$allo4.exclude)
          }
        };
      }
      break;
    case 'none':
      actions.migrate = {
        ...(originalActions === null || originalActions === void 0 ? void 0 : originalActions.migrate),
        enabled: false
      };
      break;
    default:
  }
  if (numberOfReplicas != null) {
    actions.allocate = {
      ...actions.allocate,
      number_of_replicas: numberOfReplicas
    };
  }
  return actions;
};
exports.serializeMigrateAndAllocateActions = serializeMigrateAndAllocateActions;