"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnhancedUseField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _form_errors_context = require("../form_errors_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// We wrap this component for edit policy so we do not export it from the "shared_imports" dir to avoid
// accidentally using the non-enhanced version.
const isXPhaseField = phase => fieldPath => fieldPath.startsWith(`phases.${phase}`) || fieldPath.startsWith(`_meta.${phase}`);
const isHotPhaseField = isXPhaseField('hot');
const isWarmPhaseField = isXPhaseField('warm');
const isColdPhaseField = isXPhaseField('cold');
const isFrozenPhaseField = isXPhaseField('frozen');
const isDeletePhaseField = isXPhaseField('delete');
const determineFieldPhase = fieldPath => {
  if (isHotPhaseField(fieldPath)) {
    return 'hot';
  }
  if (isWarmPhaseField(fieldPath)) {
    return 'warm';
  }
  if (isColdPhaseField(fieldPath)) {
    return 'cold';
  }
  if (isFrozenPhaseField(fieldPath)) {
    return 'frozen';
  }
  if (isDeletePhaseField(fieldPath)) {
    return 'delete';
  }
  return 'other';
};
const EnhancedUseField = props => {
  const {
    path
  } = props;
  const isMounted = (0, _react.useRef)(false);
  const phase = (0, _react.useMemo)(() => determineFieldPhase(path), [path]);
  const {
    addError,
    clearError
  } = (0, _form_errors_context.useFormErrorsContext)();
  const onError = (0, _react.useCallback)(errors => {
    if (!isMounted.current) {
      return;
    }
    if (errors) {
      addError(phase, path, errors);
    } else {
      clearError(phase, path);
    }
  }, [phase, path, addError, clearError]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);

  // Make sure to clear error message if the field is unmounted.
  (0, _react.useEffect)(() => {
    return () => {
      if (isMounted.current === false) {
        clearError(phase, path);
      }
    };
  }, [phase, path, clearError]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, (0, _extends2.default)({}, props, {
    onError: onError
  }));
};
exports.EnhancedUseField = EnhancedUseField;