"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recentlyAccessedShape = exports.RecentlyAccessed = exports.NUM_LONG_LINKS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NUM_LONG_LINKS = 5;
exports.NUM_LONG_LINKS = NUM_LONG_LINKS;
class RecentlyAccessed extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderDropdown", () => {
      if (this.props.recentlyAccessed.length <= NUM_LONG_LINKS) {
        return;
      }
      const dropdownLinks = [];
      for (let i = NUM_LONG_LINKS; i < this.props.recentlyAccessed.length; i++) {
        dropdownLinks.push( /*#__PURE__*/_react.default.createElement("li", {
          style: {
            marginBottom: 8
          },
          key: this.props.recentlyAccessed[i].id,
          "data-test-subj": `moreRecentlyAccessedItem${this.props.recentlyAccessed[i].id}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          className: "homRecentlyAccessed__dropdownLink",
          href: this.props.recentlyAccessed[i].link
        }, this.props.recentlyAccessed[i].label)));
      }
      const openPopoverComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.onButtonClick,
        "data-test-subj": "openMoreRecentlyAccessedPopover"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        className: "homRecentlyAccessed__dropdownLabel",
        color: "subdued"
      }, `${dropdownLinks.length} more`), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowDown",
        color: "subdued"
      }));
      let anchorPosition = 'downRight';
      if (window.innerWidth <= 768) {
        anchorPosition = 'downLeft';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        id: "popover",
        button: openPopoverComponent,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        anchorPosition: anchorPosition
      }, /*#__PURE__*/_react.default.createElement("ul", null, dropdownLinks));
    });
    (0, _defineProperty2.default)(this, "renderLongLink", (recentlyAccessedItem, includeSeparator = false) => {
      let separator;
      if (includeSeparator) {
        separator = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "homRecentlyAccessed__separator"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "dot",
          color: "subdued"
        })));
      }
      // Want to avoid a bunch of white space around items with short labels (happens when min width is too large).
      // Also want to avoid truncating really short names (happens when there is no min width)
      // Dynamically setting the min width based on label length meets both of these goals.
      const EM_RATIO = 0.65; // 'em' ratio that avoids too much horizontal white space and too much truncation
      const minWidth = (recentlyAccessedItem.label.length < 8 ? recentlyAccessedItem.label.length : 8) * EM_RATIO;
      const style = {
        minWidth: `${minWidth}em`
      };
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: recentlyAccessedItem.id
      }, separator, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        className: "homRecentlyAccessed__item",
        style: style,
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        anchorClassName: "homRecentlyAccessed__anchor",
        position: "bottom",
        content: recentlyAccessedItem.label
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        className: "homRecentlyAccessed__longLink",
        href: recentlyAccessedItem.link
      }, recentlyAccessedItem.label))));
    });
    (0, _defineProperty2.default)(this, "renderRecentlyAccessed", () => {
      if (this.props.recentlyAccessed.length <= NUM_LONG_LINKS) {
        return this.props.recentlyAccessed.map((item, index) => {
          let includeSeparator = true;
          if (index === 0) {
            includeSeparator = false;
          }
          return this.renderLongLink(item, includeSeparator);
        });
      }
      const links = [];
      for (let i = 0; i < NUM_LONG_LINKS; i++) {
        let includeSeparator = true;
        if (i === 0) {
          includeSeparator = false;
        }
        links.push(this.renderLongLink(this.props.recentlyAccessed[i], includeSeparator));
      }
      return links;
    });
    this.state = {
      isPopoverOpen: false
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.recentlyAccessed.recentlyViewedTitle",
      defaultMessage: "Recently viewed"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexEnd",
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "homRecentlyAccessed__flexItem"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, this.renderRecentlyAccessed())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.renderDropdown())));
  }
}
exports.RecentlyAccessed = RecentlyAccessed;
const recentlyAccessedShape = _propTypes.default.shape({
  label: _propTypes.default.string.isRequired,
  link: _propTypes.default.string.isRequired,
  id: _propTypes.default.string.isRequired
});
exports.recentlyAccessedShape = recentlyAccessedShape;
RecentlyAccessed.propTypes = {
  recentlyAccessed: _propTypes.default.arrayOf(recentlyAccessedShape).isRequired
};