"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidancePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _state_management = require("../../state_management");
var _source_modal = require("../../services/source_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ListItem({
  children,
  state
}) {
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/role-supports-aria-props
    _react.default.createElement("li", {
      className: (0, _classnames.default)('gphGuidancePanel__item', {
        'gphGuidancePanel__item--disabled': state === 'disabled'
      }),
      "aria-disabled": state === 'disabled',
      "aria-current": state === 'active' ? 'step' : undefined
    }, state !== 'disabled' && /*#__PURE__*/_react.default.createElement("span", {
      className: (0, _classnames.default)('gphGuidancePanel__itemIcon', {
        'gphGuidancePanel__itemIcon--done': state === 'done'
      }),
      "aria-hidden": true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: state === 'active' ? 'sortRight' : 'check'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, children))
  );
}
function GuidancePanelComponent(props) {
  const {
    onFillWorkspace,
    onOpenFieldPicker,
    onIndexPatternSelected,
    hasDatasource,
    hasFields
  } = props;
  const kibana = (0, _public.useKibana)();
  const {
    services,
    overlays
  } = kibana;
  const {
    application,
    data,
    contentManagement,
    uiSettings
  } = services;
  const [hasDataViews, setHasDataViews] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const checkIfDataViewsExist = async () => {
      setHasDataViews(await data.dataViews.hasData.hasUserDataView());
    };
    checkIfDataViewsExist();
  }, [setHasDataViews, data.dataViews]);
  if (!overlays || !application) return null;
  const onOpenDatasourcePicker = () => {
    (0, _source_modal.openSourceModal)({
      overlays,
      contentManagement,
      uiSettings
    }, onIndexPatternSelected);
  };
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "graphGuidancePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "graphApp",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
    id: "graphHeading"
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.title', {
    defaultMessage: 'Three steps to your graph'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("ol", {
    className: "gphGuidancePanel__list",
    "aria-labelledby": "graphHeading"
  }, /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasDatasource ? 'done' : 'active'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenDatasourcePicker
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.datasourceItem.indexPatternButtonLabel', {
    defaultMessage: 'Select a data source.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'done' : hasDatasource ? 'active' : 'disabled'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenFieldPicker,
    disabled: !hasFields && !hasDatasource
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.fieldsItem.fieldsButtonLabel', {
    defaultMessage: 'Add fields.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'active' : 'disabled'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.guidancePanel.nodesItem.description",
    defaultMessage: "Enter a query in the search bar to start exploring. Don't know where to start? {topTerms}.",
    values: {
      topTerms: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onFillWorkspace,
        disabled: !hasFields
      }, _i18n.i18n.translate('xpack.graph.guidancePanel.nodesItem.topTermsButtonLabel', {
        defaultMessage: 'Graph the top terms'
      }))
    }
  }))))));
  if (!hasDataViews) {
    const dataViewManagementUrl = application.getUrlForApp('management', {
      path: '/kibana/dataViews'
    });
    const sampleDataUrl = `${application.getUrlForApp('home')}#/tutorial_directory/sampleData`;
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "help",
      title: _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
        defaultMessage: 'No data source'
      }),
      heading: "h1"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
      id: "graphHeading"
    }, _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
      defaultMessage: 'No data source'
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.noDataSourceNotificationMessageText",
      defaultMessage: "No data sources found. Go to {managementIndexPatternsLink} and create a data view for your Elasticsearch indices.",
      values: {
        managementIndexPatternsLink: /*#__PURE__*/_react.default.createElement("a", {
          href: dataViewManagementUrl
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.noDataSourceNotificationMessageText.managementDataViewLinkText",
          defaultMessage: "Management > Data views"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.noDataSource.newToKibanaDescription",
      defaultMessage: "New to Kibana? You can also use our {sampleDataInstallLink}.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: sampleDataUrl
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.listing.noDataSource.sampleDataInstallLinkText",
          defaultMessage: "sample data"
        }))
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "gphGuidancePanel"
  }, content));
}
const GuidancePanel = (0, _reactRedux.connect)(state => {
  return {
    hasDatasource: (0, _state_management.hasDatasourceSelector)(state),
    hasFields: (0, _state_management.hasFieldsSelector)(state)
  };
}, dispatch => ({
  onIndexPatternSelected: indexPattern => {
    dispatch((0, _state_management.requestDatasource)({
      type: 'indexpattern',
      id: indexPattern.id,
      title: indexPattern.attributes.title
    }));
  },
  onFillWorkspace: () => {
    dispatch((0, _state_management.fillWorkspace)());
  }
}))(GuidancePanelComponent);
exports.GuidancePanel = GuidancePanel;