"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldType = exports.EventMetric = exports.CountMetric = exports.ClickMetric = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* @internal */
let CountMetric;
/* @internal */
exports.CountMetric = CountMetric;
(function (CountMetric) {
  CountMetric["UNHANDLED_ERROR"] = "unhandled_error";
  CountMetric["SHORTCUT_USED"] = "shortcut_used";
  CountMetric["SEARCH_FOCUS"] = "search_focus";
  CountMetric["SEARCH_REQUEST"] = "search_request";
})(CountMetric || (exports.CountMetric = CountMetric = {}));
let ClickMetric;
/* @internal */
exports.ClickMetric = ClickMetric;
(function (ClickMetric) {
  ClickMetric["USER_NAVIGATED_TO_APPLICATION"] = "user_navigated_to_application";
  ClickMetric["USER_NAVIGATED_TO_SAVED_OBJECT"] = "user_navigated_to_saved_object";
})(ClickMetric || (exports.ClickMetric = ClickMetric = {}));
let EventMetric;
/* @internal */
exports.EventMetric = EventMetric;
(function (EventMetric) {
  EventMetric["CLICK_APPLICATION"] = "global_search_bar_click_application";
  EventMetric["CLICK_SAVED_OBJECT"] = "global_search_bar_click_saved_object";
  EventMetric["SEARCH_BLUR"] = "global_search_bar_blur";
  EventMetric["ERROR"] = "global_search_bar_error";
})(EventMetric || (exports.EventMetric = EventMetric = {}));
let FieldType;
/* @internal */
exports.FieldType = FieldType;
(function (FieldType) {
  FieldType["APPLICATION"] = "application";
  FieldType["SAVED_OBJECT_TYPE"] = "saved_object_type";
  FieldType["FOCUS_TIME"] = "focus_time_ms";
  FieldType["SELECTED_LABEL"] = "selected_label";
  FieldType["SELECTED_RANK"] = "selected_rank";
  FieldType["ERROR_MESSAGE"] = "error_message";
  FieldType["TERMS"] = "terms";
})(FieldType || (exports.FieldType = FieldType = {}));
/* @internal */
/* @internal */
/* @internal */