"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventTypes = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fields = {
  [_types.FieldType.APPLICATION]: {
    [_types.FieldType.APPLICATION]: {
      type: 'keyword',
      _meta: {
        description: 'The name of the application selected in the global search bar results.'
      }
    }
  },
  [_types.FieldType.SAVED_OBJECT_TYPE]: {
    [_types.FieldType.SAVED_OBJECT_TYPE]: {
      type: 'keyword',
      _meta: {
        description: 'The type of the saved object selected in the global search bar results.'
      }
    }
  },
  [_types.FieldType.FOCUS_TIME]: {
    [_types.FieldType.FOCUS_TIME]: {
      type: 'long',
      _meta: {
        description: 'The length in milliseconds the global search bar had the cursor focused.'
      }
    }
  },
  [_types.FieldType.SELECTED_RANK]: {
    [_types.FieldType.SELECTED_RANK]: {
      type: 'short',
      _meta: {
        description: 'The ranking of placement of the selected option in the results list.'
      }
    }
  },
  [_types.FieldType.SELECTED_LABEL]: {
    [_types.FieldType.SELECTED_LABEL]: {
      type: 'keyword',
      _meta: {
        description: 'The text of the selected option in the results list.'
      }
    }
  },
  [_types.FieldType.ERROR_MESSAGE]: {
    [_types.FieldType.ERROR_MESSAGE]: {
      type: 'keyword',
      _meta: {
        description: 'A message from an error that was caught.'
      }
    }
  },
  [_types.FieldType.TERMS]: {
    [_types.FieldType.TERMS]: {
      type: 'keyword',
      _meta: {
        description: 'The search terms entered by the user.'
      }
    }
  }
};
const eventTypes = [{
  eventType: _types.EventMetric.CLICK_APPLICATION,
  schema: {
    ...fields[_types.FieldType.APPLICATION],
    ...fields[_types.FieldType.TERMS],
    ...fields[_types.FieldType.SELECTED_RANK],
    ...fields[_types.FieldType.SELECTED_LABEL]
  }
}, {
  eventType: _types.EventMetric.CLICK_SAVED_OBJECT,
  schema: {
    ...fields[_types.FieldType.SAVED_OBJECT_TYPE],
    ...fields[_types.FieldType.TERMS],
    ...fields[_types.FieldType.SELECTED_RANK],
    ...fields[_types.FieldType.SELECTED_LABEL]
  }
}, {
  eventType: _types.EventMetric.SEARCH_BLUR,
  schema: {
    ...fields[_types.FieldType.FOCUS_TIME]
  }
}, {
  eventType: _types.EventMetric.ERROR,
  schema: {
    ...fields[_types.FieldType.ERROR_MESSAGE],
    ...fields[_types.FieldType.TERMS]
  }
}];
exports.eventTypes = eventTypes;