"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PutFleetProxyRequestSchema = exports.PostFleetProxyRequestSchema = exports.GetOneFleetProxyRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PostFleetProxyRequestSchema = {
  body: _configSchema.schema.object({
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    url: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    proxy_headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean(), _configSchema.schema.number()]))),
    certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.string()),
    certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
    certificate_key: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
exports.PostFleetProxyRequestSchema = PostFleetProxyRequestSchema;
const PutFleetProxyRequestSchema = {
  params: _configSchema.schema.object({
    itemId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    url: _configSchema.schema.maybe(_configSchema.schema.string()),
    proxy_headers: _configSchema.schema.nullable(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean(), _configSchema.schema.number()]))),
    certificate_authorities: _configSchema.schema.nullable(_configSchema.schema.string()),
    certificate: _configSchema.schema.nullable(_configSchema.schema.string()),
    certificate_key: _configSchema.schema.nullable(_configSchema.schema.string())
  })
};
exports.PutFleetProxyRequestSchema = PutFleetProxyRequestSchema;
const GetOneFleetProxyRequestSchema = {
  params: _configSchema.schema.object({
    itemId: _configSchema.schema.string()
  })
};
exports.GetOneFleetProxyRequestSchema = GetOneFleetProxyRequestSchema;