"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allFleetServerVersionsAreAtLeast = allFleetServerVersionsAreAtLeast;
exports.hasFleetServers = hasFleetServers;
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _constants = require("../../constants");
var _agents = require("../agents");
var _package_policy = require("../package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check if at least one fleet server is connected
 */
async function hasFleetServers(esClient) {
  const res = await esClient.search({
    index: _constants.FLEET_SERVER_SERVERS_INDEX,
    ignore_unavailable: true,
    filter_path: 'hits.total',
    track_total_hits: true,
    rest_total_hits_as_int: true
  });
  return res.hits.total > 0;
}
async function allFleetServerVersionsAreAtLeast(esClient, soClient, version) {
  let hasMore = true;
  const policyIds = new Set();
  let page = 1;
  while (hasMore) {
    const res = await _package_policy.packagePolicyService.list(soClient, {
      page: page++,
      perPage: 20,
      kuery: 'ingest-package-policies.package.name:fleet_server'
    });
    for (const item of res.items) {
      policyIds.add(item.policy_id);
    }
    if (res.items.length === 0) {
      hasMore = false;
    }
  }
  const versionCounts = await (0, _agents.getAgentVersionsForAgentPolicyIds)(esClient, [...policyIds]);
  const versions = Object.keys(versionCounts);

  // there must be at least one fleet server agent for this check to pass
  if (versions.length === 0) {
    return false;
  }
  return _allVersionsAreAtLeast(version, versions);
}
function _allVersionsAreAtLeast(version, versions) {
  return versions.every(v => (0, _gte.default)((0, _coerce.default)(v), version));
}