"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cacheAssets = void 0;
var _archive = require("../../../archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cacheAssets = (assets, name, version) => {
  const paths = assets.map(asset => asset.path);
  (0, _archive.setArchiveFilelist)({
    name,
    version
  }, paths);
  assets.forEach(asset => {
    (0, _archive.setArchiveEntry)(asset.path, asset.content);
  });
  return paths;
};
exports.cacheAssets = cacheAssets;