"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchRelatedSavedObjects = fetchRelatedSavedObjects;
var _lodash = require("lodash");
var _output = require("../output");
var _source_uri_utils = require("../../routes/agent/source_uri_utils");
var _fleet_server_host = require("../fleet_server_host");
var _app_context = require("../app_context");
var _fleet_proxies = require("../fleet_proxies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchRelatedSavedObjects(soClient, agentPolicy) {
  const [defaultDataOutputId, defaultMonitoringOutputId] = await Promise.all([_output.outputService.getDefaultDataOutputId(soClient), _output.outputService.getDefaultMonitoringOutputId(soClient)]);
  if (!defaultDataOutputId) {
    throw new Error('Default output is not setup');
  }
  const dataOutputId = agentPolicy.data_output_id || defaultDataOutputId;
  const monitoringOutputId = agentPolicy.monitoring_output_id || defaultMonitoringOutputId || dataOutputId;
  const [outputs, {
    host: downloadSourceUri,
    proxy_id: downloadSourceProxyId
  }, fleetServerHosts] = await Promise.all([_output.outputService.bulkGet(soClient, (0, _lodash.uniq)([dataOutputId, monitoringOutputId]), {
    ignoreNotFound: true
  }), (0, _source_uri_utils.getSourceUriForAgentPolicy)(soClient, agentPolicy), (0, _fleet_server_host.getFleetServerHostsForAgentPolicy)(soClient, agentPolicy).catch(err => {
    var _appContextService$ge;
    (_appContextService$ge = _app_context.appContextService.getLogger()) === null || _appContextService$ge === void 0 ? void 0 : _appContextService$ge.warn(`Unable to get fleet server hosts for policy ${agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id}: ${err.message}`);
    return;
  })]);
  const dataOutput = outputs.find(output => output.id === dataOutputId);
  if (!dataOutput) {
    throw new Error(`Data output not found ${dataOutputId}`);
  }
  const monitoringOutput = outputs.find(output => output.id === monitoringOutputId);
  if (!monitoringOutput) {
    throw new Error(`Monitoring output not found ${monitoringOutputId}`);
  }
  const proxyIds = (0, _lodash.uniq)(outputs.flatMap(output => output.proxy_id).filter(proxyId => typeof proxyId !== 'undefined' && proxyId !== null).concat(fleetServerHosts !== null && fleetServerHosts !== void 0 && fleetServerHosts.proxy_id ? [fleetServerHosts.proxy_id] : []).concat(downloadSourceProxyId ? [downloadSourceProxyId] : []));
  const proxies = proxyIds.length ? await (0, _fleet_proxies.bulkGetFleetProxies)(soClient, proxyIds) : [];
  let downloadSourceProxyUri = null;
  if (downloadSourceProxyId) {
    const downloadSourceProxy = proxies.find(proxy => proxy.id === downloadSourceProxyId);
    if (downloadSourceProxy) {
      downloadSourceProxyUri = downloadSourceProxy.url;
    }
  }
  return {
    outputs,
    proxies,
    dataOutput,
    monitoringOutput,
    downloadSourceUri,
    downloadSourceProxyUri,
    fleetServerHosts
  };
}