"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetDeepLinks = exports.FleetDeepLinkId = void 0;
var _i18n = require("@kbn/i18n");
var _page_paths = require("./constants/page_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FleetDeepLinkId;
exports.FleetDeepLinkId = FleetDeepLinkId;
(function (FleetDeepLinkId) {
  FleetDeepLinkId["agents"] = "agents";
  FleetDeepLinkId["policies"] = "policies";
  FleetDeepLinkId["enrollmentTokens"] = "enrollment_tokens";
  FleetDeepLinkId["uninstallTokens"] = "uninstall_tokens";
  FleetDeepLinkId["dataStreams"] = "data_streams";
  FleetDeepLinkId["settings"] = "settings";
})(FleetDeepLinkId || (exports.FleetDeepLinkId = FleetDeepLinkId = {}));
const getFleetDeepLinks = experimentalFeatures => [{
  id: FleetDeepLinkId.agents,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.agents.title', {
    defaultMessage: 'Agents'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.agents
}, {
  id: FleetDeepLinkId.policies,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.policies.title', {
    defaultMessage: 'Agent policies'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.policies
}, {
  id: FleetDeepLinkId.enrollmentTokens,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.enrollmentTokens.title', {
    defaultMessage: 'Enrollment tokens'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.enrollment_tokens
}, ...(experimentalFeatures.agentTamperProtectionEnabled ? [{
  id: FleetDeepLinkId.uninstallTokens,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.uninstallTokens.title', {
    defaultMessage: 'Uninstall tokens'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.uninstall_tokens
}] : []), {
  id: FleetDeepLinkId.dataStreams,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.dataStreams.title', {
    defaultMessage: 'Data streams'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.data_streams
}, {
  id: FleetDeepLinkId.settings,
  title: _i18n.i18n.translate('xpack.fleet.deepLinks.settings.title', {
    defaultMessage: 'Settings'
  }),
  path: _page_paths.FLEET_ROUTING_PATHS.settings
}];
exports.getFleetDeepLinks = getFleetDeepLinks;