"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContextMenuActions = /*#__PURE__*/_react.default.memo(({
  button,
  onChange,
  isOpen,
  ...props
}) => {
  const [isOpenState, setIsOpenState] = (0, _react.useState)(false);
  const handleCloseMenu = (0, _react.useCallback)(() => {
    if (onChange) {
      onChange(false);
    } else {
      setIsOpenState(false);
    }
  }, [setIsOpenState, onChange]);
  const handleToggleMenu = (0, _react.useCallback)(() => {
    if (onChange) {
      onChange(!isOpen);
    } else {
      setIsOpenState(!isOpenState);
    }
  }, [isOpenState, onChange, isOpen]);
  const actionButton = button ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, button.props, {
    onClick: handleToggleMenu,
    isDisabled: props.isManaged
  }), button.children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: props.isManaged,
    iconType: "boxesHorizontal",
    onClick: handleToggleMenu,
    "aria-label": _i18n.i18n.translate('xpack.fleet.genericActionsMenuText', {
      defaultMessage: 'Open'
    }),
    "data-test-subj": "agentActionsBtn"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: props.isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: _i18n.i18n.translate('xpack.fleet.externallyManagedLabel', {
        defaultMessage: 'This is externally managed integration policy.'
      })
    }, actionButton) : actionButton,
    isOpen: isOpen === undefined ? isOpenState : isOpen,
    closePopover: handleCloseMenu
  }, 'items' in props ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: props.items
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: props.panels,
    initialPanelId: 0
  }));
});
exports.ContextMenuActions = ContextMenuActions;