"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallGoogleCloudShellManagedAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _google_cloud_shell_instructions = require("../google_cloud_shell_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallGoogleCloudShellManagedAgentStep = ({
  selectedApiKeyId,
  apiKeyData,
  isComplete,
  cloudShellUrl,
  cloudShellCommand,
  projectId
}) => {
  const nonCompleteStatus = selectedApiKeyId ? undefined : 'disabled';
  const status = isComplete ? 'complete' : nonCompleteStatus;
  return {
    status,
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudShell.stepEnrollAndRunAgentTitle', {
      defaultMessage: 'Install Elastic Agent on your cloud'
    }),
    children: selectedApiKeyId && apiKeyData && cloudShellUrl ? /*#__PURE__*/_react.default.createElement(_google_cloud_shell_instructions.GoogleCloudShellInstructions, {
      cloudShellUrl: cloudShellUrl || '',
      cloudShellCommand: cloudShellCommand || '',
      projectId: projectId || ''
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
  };
};
exports.InstallGoogleCloudShellManagedAgentStep = InstallGoogleCloudShellManagedAgentStep;