"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomViewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../services");
var _components = require("../../../../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomViewPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo
}) => {
  const customViewExtension = (0, _hooks.useUIExtension)(packageInfo.name, 'package-detail-custom');
  const {
    getPath
  } = (0, _hooks.useLink)();
  const pkgkey = (0, _react.useMemo)(() => (0, _services.pkgKeyFromPackageInfo)(packageInfo), [packageInfo]);
  return customViewExtension ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(customViewExtension.Component, {
    pkgkey: pkgkey,
    packageInfo: packageInfo
  })))) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: getPath('integration_details_overview', {
      pkgkey
    })
  });
});
exports.CustomViewPage = CustomViewPage;