"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _output_health = require("../edit_output_flyout/output_health");
var _badges = require("./badges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;

// Allow child to be truncated
const FlexGroupWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 0px;
`;
function displayOutputType(type) {
  switch (type) {
    case 'elasticsearch':
      return _i18n.i18n.translate('xpack.fleet.settings.outputsTable.elasticsearchTypeLabel', {
        defaultMessage: 'Elasticsearch'
      });
    case 'remote_elasticsearch':
      return _i18n.i18n.translate('xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel', {
        defaultMessage: 'Remote Elasticsearch'
      });
    default:
      return type;
  }
}
const OutputsTable = ({
  outputs,
  deleteOutput
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: output => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: output.name,
        className: `eui-textTruncate`
      }, output.name)), output.is_preconfigured && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.managedTooltip', {
          defaultMessage: 'This output is managed outside of Fleet.'
        }),
        type: "lock",
        size: "m",
        color: "subdued"
      }))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      width: '172px',
      render: output => displayOutputType(output.type),
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.typeColumnTitle', {
        defaultMessage: 'Type'
      })
    }, {
      truncateText: true,
      render: output => /*#__PURE__*/_react.default.createElement(FlexGroupWithMinWidth, {
        direction: "column",
        gutterSize: "xs"
      }, (output.hosts || []).map(host => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: host
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: host,
        className: `eui-textTruncate`
      }, host)))),
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.hostColumnTitle', {
        defaultMessage: 'Hosts'
      })
    }, {
      render: output => {
        return output !== null && output !== void 0 && output.id && output.type === 'remote_elasticsearch' ? /*#__PURE__*/_react.default.createElement(_output_health.OutputHealth, {
          output: output,
          showBadge: true
        }) : null;
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.statusColumnTitle', {
        defaultMessage: 'Status'
      })
    }, {
      render: output => /*#__PURE__*/_react.default.createElement(_badges.DefaultBadges, {
        output: output
      }),
      width: '200px',
      name: _i18n.i18n.translate('xpack.fleet.settings.outputSection.defaultColumnTitle', {
        defaultMessage: 'Default'
      })
    }, {
      width: '68px',
      render: output => {
        const isDeleteVisible = !output.is_default && !output.is_default_monitoring && !output.is_preconfigured;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "trash",
          onClick: () => deleteOutput(output),
          title: _i18n.i18n.translate('xpack.fleet.settings.outputSection.deleteButtonTitle', {
            defaultMessage: 'Delete'
          })
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_outputs', {
            outputId: output.id
          }),
          title: _i18n.i18n.translate('xpack.fleet.settings.outputSection.editButtonTitle', {
            defaultMessage: 'Edit'
          }),
          "data-test-subj": "editOutputBtn"
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.outputSection.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [deleteOutput, getHref]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: outputs
  });
};
exports.OutputsTable = OutputsTable;