"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaBroker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormKafkaBroker = props => {
  const {
    inputs
  } = props;
  const kafkaBrokerTimeoutOptions = (0, _react.useMemo)(() => Array.from({
    length: 6
  }, (_, i) => (i + 1) * 10).map(timeout => ({
    text: timeout,
    label: `${timeout} seconds`
  })), []);
  const getAckReliabilityLabel = value => {
    switch (value) {
      case _constants.kafkaAcknowledgeReliabilityLevel.DoNotWait:
        return 'No response';
      case _constants.kafkaAcknowledgeReliabilityLevel.Replica:
        return 'Wait for all replicas to commit';
      default:
      case _constants.kafkaAcknowledgeReliabilityLevel.Commit:
        return 'Wait for local commit';
    }
  };
  const kafkaBrokerAckReliabilityOptions = (0, _react.useMemo)(() => Object.keys(_constants.kafkaAcknowledgeReliabilityLevel).map(key => {
    return {
      text: _constants.kafkaAcknowledgeReliabilityLevel[key],
      label: getAckReliabilityLabel(_constants.kafkaAcknowledgeReliabilityLevel[key])
    };
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerSettingsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaBrokerSettings"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",
    defaultMessage: "Broker settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",
      defaultMessage: "Broker timeout"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",
      defaultMessage: "Define how long a Kafka server waits for data in the same cluster."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerTimeoutInput"
  }, inputs.kafkaBrokerTimeoutInput.props, {
    options: kafkaBrokerTimeoutOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",
      defaultMessage: "Broker reachability timeout"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",
      defaultMessage: "Define how long an Agent would wait for a response from Kafka broker."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"
  }, inputs.kafkaBrokerReachabilityTimeoutInput.props, {
    options: kafkaBrokerTimeoutOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",
      defaultMessage: "ACK Reliability"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",
      defaultMessage: "Reliability level required from the broker."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"
  }, inputs.kafkaBrokerAckReliabilityInput.props, {
    options: kafkaBrokerAckReliabilityOptions
  }))));
};
exports.OutputFormKafkaBroker = OutputFormKafkaBroker;