"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudInstructions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_INTERVAL = 10000;
const CloudInstructions = ({
  deploymentUrl
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    refresh
  } = (0, _hooks.useFleetStatus)();
  (0, _react.useEffect)(() => {
    const interval = setInterval(() => {
      refresh();
    }, REFRESH_INTERVAL);
    return () => clearInterval(interval);
  }, [refresh]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.cloudSetupTitle",
      defaultMessage: "Enable Fleet Server"
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.cloudSetupText",
      defaultMessage: "A Fleet Server is required before you can enroll agents with Fleet. The easiest way to get one is by adding an Integration Server, which runs the Fleet Server integration. You can add it to your deployment in the Cloud Console. For more information see the {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.fleetServerAddFleetServer,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.userGuideLink",
          defaultMessage: "Fleet and Elastic Agent Guide"
        }))
      }
    }),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconSide: "right",
      iconType: "popout",
      fill: true,
      isLoading: false,
      type: "submit",
      href: `${deploymentUrl}/edit`,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.cloudDeploymentLink",
      defaultMessage: "Edit deployment"
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.waitingText",
    defaultMessage: "Waiting for a Fleet Server to connect..."
  }))))));
};
exports.CloudInstructions = CloudInstructions;